/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.history;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BHistorySummary is a struct that contains the summary info
 * for a history.
 *
 * @author    John Sublett
 * @creation  03 Apr 2003
 * @version   $Revision: 1$ $Date: 10/13/03 11:15:59 AM EDT$
 * @since     Baja 1.0
 */
public class BHistorySummary
  extends BStruct
{
  /*-

  class BHistorySummary
  {
    properties
    {
      id: BHistoryId
        -- The id of the history with this state.
        default {[ BHistoryId.NULL ]}

      recordCount: int
        -- The number of records in the history.
        default {[ 0 ]}

      firstTimestamp: BAbsTime
        -- The timestamp of the first record in the history.
        default {[ BAbsTime.NULL ]}

      lastTimestamp: BAbsTime
        -- The timestamp of the last record in the history.
        default {[ BAbsTime.NULL ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BHistorySummary(40449858)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>id</code> property.
   * The id of the history with this state.
   * @see javax.baja.history.BHistorySummary#getId
   * @see javax.baja.history.BHistorySummary#setId
   */
  public static final Property id = newProperty(0, BHistoryId.NULL,null);

  /**
   * Get the <code>id</code> property.
   * The id of the history with this state.
   * @see javax.baja.history.BHistorySummary#id
   */
  public BHistoryId getId() { return (BHistoryId)get(id); }

  /**
   * Set the <code>id</code> property.
   * The id of the history with this state.
   * @see javax.baja.history.BHistorySummary#id
   */
  public void setId(BHistoryId v) { set(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "recordCount"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>recordCount</code> property.
   * The number of records in the history.
   * @see javax.baja.history.BHistorySummary#getRecordCount
   * @see javax.baja.history.BHistorySummary#setRecordCount
   */
  public static final Property recordCount = newProperty(0, 0,null);

  /**
   * Get the <code>recordCount</code> property.
   * The number of records in the history.
   * @see javax.baja.history.BHistorySummary#recordCount
   */
  public int getRecordCount() { return getInt(recordCount); }

  /**
   * Set the <code>recordCount</code> property.
   * The number of records in the history.
   * @see javax.baja.history.BHistorySummary#recordCount
   */
  public void setRecordCount(int v) { setInt(recordCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "firstTimestamp"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>firstTimestamp</code> property.
   * The timestamp of the first record in the history.
   * @see javax.baja.history.BHistorySummary#getFirstTimestamp
   * @see javax.baja.history.BHistorySummary#setFirstTimestamp
   */
  public static final Property firstTimestamp = newProperty(0, BAbsTime.NULL,null);

  /**
   * Get the <code>firstTimestamp</code> property.
   * The timestamp of the first record in the history.
   * @see javax.baja.history.BHistorySummary#firstTimestamp
   */
  public BAbsTime getFirstTimestamp() { return (BAbsTime)get(firstTimestamp); }

  /**
   * Set the <code>firstTimestamp</code> property.
   * The timestamp of the first record in the history.
   * @see javax.baja.history.BHistorySummary#firstTimestamp
   */
  public void setFirstTimestamp(BAbsTime v) { set(firstTimestamp,v,null); }

////////////////////////////////////////////////////////////////
// Property "lastTimestamp"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>lastTimestamp</code> property.
   * The timestamp of the last record in the history.
   * @see javax.baja.history.BHistorySummary#getLastTimestamp
   * @see javax.baja.history.BHistorySummary#setLastTimestamp
   */
  public static final Property lastTimestamp = newProperty(0, BAbsTime.NULL,null);

  /**
   * Get the <code>lastTimestamp</code> property.
   * The timestamp of the last record in the history.
   * @see javax.baja.history.BHistorySummary#lastTimestamp
   */
  public BAbsTime getLastTimestamp() { return (BAbsTime)get(lastTimestamp); }

  /**
   * Set the <code>lastTimestamp</code> property.
   * The timestamp of the last record in the history.
   * @see javax.baja.history.BHistorySummary#lastTimestamp
   */
  public void setLastTimestamp(BAbsTime v) { set(lastTimestamp,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistorySummary.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}