/*
 * Copyright 2007, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.history;

import javax.baja.chart.binding.BAxisBound;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BHistoryPointListItem
 *
 * @author    John Huffman
 * @creation  19 Jul 2007
 * @version   $Revision: 6$ $Date: 9/12/07 3:16:01 PM EDT$
 * @since     Baja 1.0
 */
public class BHistoryPointListItem
  extends BComponent
//  extends BStruct  // The problem with extending BStruct is you can't add/remove/hide/unhide slots on the fly.
                     // I want to be able to add a slot for the user to be able to enter the point name
                     // when the "addPoint" action is invoked in BHistoryPointList but not be visible on the property sheet view.
{
  /*-

  class BHistoryPointListItem
  {
    properties
    {
      historyExtension: BOrd
        -- The ord to the history point
        default {[ BOrd.DEFAULT ]}

      displayOnStartup: boolean
        -- Indicates whether this point should be charted when the view is displayed
        default {[ true ]}

      startTime: BRelTime
        -- Offset from the current time
        default {[ BRelTime.make(0L * 60L * 60L * 1000L) ]}
        --                Modify ^ to control the number of hours
        slotfacets {[ BFacets.make( BFacets.SHOW_SECONDS, BBoolean.make(false),
                                    BFacets.MIN, BRelTime.makeHours(0) ) ]}

      sampleRate: BSampleRate
        -- The frequency of live updates
        default {[ BSampleRate.DEFAULT ]}

      minValueRange: BAxisBound
        -- The min and max range for the values of this point
        default {[ BAxisBound.make( BDouble.make(0)) ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("chart:NumericAxisBoundFE")) ]}

      maxValueRange: BAxisBound
        -- The min and max range for the values of this point
        default {[ BAxisBound.make( BDouble.make(100)) ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("chart:NumericAxisBoundFE")) ]}

      lineColor: BColor
        -- The color of the line on the chart
        default {[ BColor.NULL ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("wbutil:ColorFE")) ]}

      pen: BPen
        -- The Pen
        default {[ BPen.DEFAULT ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BHistoryPointListItem(1156824327)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "historyExtension"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>historyExtension</code> property.
   * The ord to the history point
   * @see javax.baja.history.BHistoryPointListItem#getHistoryExtension
   * @see javax.baja.history.BHistoryPointListItem#setHistoryExtension
   */
  public static final Property historyExtension = newProperty(0, BOrd.DEFAULT,null);

  /**
   * Get the <code>historyExtension</code> property.
   * The ord to the history point
   * @see javax.baja.history.BHistoryPointListItem#historyExtension
   */
  public BOrd getHistoryExtension() { return (BOrd)get(historyExtension); }

  /**
   * Set the <code>historyExtension</code> property.
   * The ord to the history point
   * @see javax.baja.history.BHistoryPointListItem#historyExtension
   */
  public void setHistoryExtension(BOrd v) { set(historyExtension,v,null); }

////////////////////////////////////////////////////////////////
// Property "displayOnStartup"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>displayOnStartup</code> property.
   * Indicates whether this point should be charted when
   * the view is displayed
   * @see javax.baja.history.BHistoryPointListItem#getDisplayOnStartup
   * @see javax.baja.history.BHistoryPointListItem#setDisplayOnStartup
   */
  public static final Property displayOnStartup = newProperty(0, true,null);

  /**
   * Get the <code>displayOnStartup</code> property.
   * Indicates whether this point should be charted when
   * the view is displayed
   * @see javax.baja.history.BHistoryPointListItem#displayOnStartup
   */
  public boolean getDisplayOnStartup() { return getBoolean(displayOnStartup); }

  /**
   * Set the <code>displayOnStartup</code> property.
   * Indicates whether this point should be charted when
   * the view is displayed
   * @see javax.baja.history.BHistoryPointListItem#displayOnStartup
   */
  public void setDisplayOnStartup(boolean v) { setBoolean(displayOnStartup,v,null); }

////////////////////////////////////////////////////////////////
// Property "startTime"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>startTime</code> property.
   * Offset from the current time
   * @see javax.baja.history.BHistoryPointListItem#getStartTime
   * @see javax.baja.history.BHistoryPointListItem#setStartTime
   */
  public static final Property startTime = newProperty(0, BRelTime.make(0L * 60L * 60L * 1000L),BFacets.make( BFacets.SHOW_SECONDS, BBoolean.make(false),
                                    BFacets.MIN, BRelTime.makeHours(0) ) );

  /**
   * Get the <code>startTime</code> property.
   * Offset from the current time
   * @see javax.baja.history.BHistoryPointListItem#startTime
   */
  public BRelTime getStartTime() { return (BRelTime)get(startTime); }

  /**
   * Set the <code>startTime</code> property.
   * Offset from the current time
   * @see javax.baja.history.BHistoryPointListItem#startTime
   */
  public void setStartTime(BRelTime v) { set(startTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "sampleRate"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>sampleRate</code> property.
   * The frequency of live updates
   * @see javax.baja.history.BHistoryPointListItem#getSampleRate
   * @see javax.baja.history.BHistoryPointListItem#setSampleRate
   */
  public static final Property sampleRate = newProperty(0, BSampleRate.DEFAULT,null);

  /**
   * Get the <code>sampleRate</code> property.
   * The frequency of live updates
   * @see javax.baja.history.BHistoryPointListItem#sampleRate
   */
  public BSampleRate getSampleRate() { return (BSampleRate)get(sampleRate); }

  /**
   * Set the <code>sampleRate</code> property.
   * The frequency of live updates
   * @see javax.baja.history.BHistoryPointListItem#sampleRate
   */
  public void setSampleRate(BSampleRate v) { set(sampleRate,v,null); }

////////////////////////////////////////////////////////////////
// Property "minValueRange"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>minValueRange</code> property.
   * The min and max range for the values of this point
   * @see javax.baja.history.BHistoryPointListItem#getMinValueRange
   * @see javax.baja.history.BHistoryPointListItem#setMinValueRange
   */
  public static final Property minValueRange = newProperty(0, BAxisBound.make( BDouble.make(0)),BFacets.make(BFacets.FIELD_EDITOR, BString.make("chart:NumericAxisBoundFE")) );

  /**
   * Get the <code>minValueRange</code> property.
   * The min and max range for the values of this point
   * @see javax.baja.history.BHistoryPointListItem#minValueRange
   */
  public BAxisBound getMinValueRange() { return (BAxisBound)get(minValueRange); }

  /**
   * Set the <code>minValueRange</code> property.
   * The min and max range for the values of this point
   * @see javax.baja.history.BHistoryPointListItem#minValueRange
   */
  public void setMinValueRange(BAxisBound v) { set(minValueRange,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxValueRange"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxValueRange</code> property.
   * The min and max range for the values of this point
   * @see javax.baja.history.BHistoryPointListItem#getMaxValueRange
   * @see javax.baja.history.BHistoryPointListItem#setMaxValueRange
   */
  public static final Property maxValueRange = newProperty(0, BAxisBound.make( BDouble.make(100)),BFacets.make(BFacets.FIELD_EDITOR, BString.make("chart:NumericAxisBoundFE")) );

  /**
   * Get the <code>maxValueRange</code> property.
   * The min and max range for the values of this point
   * @see javax.baja.history.BHistoryPointListItem#maxValueRange
   */
  public BAxisBound getMaxValueRange() { return (BAxisBound)get(maxValueRange); }

  /**
   * Set the <code>maxValueRange</code> property.
   * The min and max range for the values of this point
   * @see javax.baja.history.BHistoryPointListItem#maxValueRange
   */
  public void setMaxValueRange(BAxisBound v) { set(maxValueRange,v,null); }

////////////////////////////////////////////////////////////////
// Property "lineColor"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>lineColor</code> property.
   * The color of the line on the chart
   * @see javax.baja.history.BHistoryPointListItem#getLineColor
   * @see javax.baja.history.BHistoryPointListItem#setLineColor
   */
  public static final Property lineColor = newProperty(0, BColor.NULL,BFacets.make(BFacets.FIELD_EDITOR, BString.make("wbutil:ColorFE")) );

  /**
   * Get the <code>lineColor</code> property.
   * The color of the line on the chart
   * @see javax.baja.history.BHistoryPointListItem#lineColor
   */
  public BColor getLineColor() { return (BColor)get(lineColor); }

  /**
   * Set the <code>lineColor</code> property.
   * The color of the line on the chart
   * @see javax.baja.history.BHistoryPointListItem#lineColor
   */
  public void setLineColor(BColor v) { set(lineColor,v,null); }

////////////////////////////////////////////////////////////////
// Property "pen"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>pen</code> property.
   * The Pen
   * @see javax.baja.history.BHistoryPointListItem#getPen
   * @see javax.baja.history.BHistoryPointListItem#setPen
   */
  public static final Property pen = newProperty(0, BPen.DEFAULT,null);

  /**
   * Get the <code>pen</code> property.
   * The Pen
   * @see javax.baja.history.BHistoryPointListItem#pen
   */
  public BPen getPen() { return (BPen)get(pen); }

  /**
   * Set the <code>pen</code> property.
   * The Pen
   * @see javax.baja.history.BHistoryPointListItem#pen
   */
  public void setPen(BPen v) { set(pen,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryPointListItem.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor.
   */
  public BHistoryPointListItem()
  {
  }

  /**
   * Overrides isParentLegal method.  BHistoryPointListItem
   * must reside under a BHistoryPointList.
   */
  @Override
  public boolean isParentLegal(BComponent parent)
  {
    return (parent instanceof BHistoryPointList);
  }

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("monitor.png");
}