/*
 * Copyright 2005 Tridium, All Rights Reserved.
 */
package com.tridium.flexSerial.point;

import javax.baja.sys.*;
import javax.baja.driver.*;
import javax.baja.driver.point.*;
import com.tridium.flexSerial.*;
import javax.baja.driver.util.*;
import javax.baja.status.*;
import com.tridium.basicdriver.point.*;
import com.tridium.basicdriver.util.*;
import com.tridium.flexSerial.messages.*;

/**
 * BFlexProxyExt
 *
 * @author    Andy Saunders
 * @creation  19-Apr-05
 * @version   $Revision$ $Date: 4/18/2005 2:51:31 PM$
 */
public class BFlexProxyExt
  extends BBasicProxyExt
 implements BIBasicPollable
{            

  /*-             
  
  class BFlexProxyExt
  {
    properties
    {
    
      pollFrequency: BPollFrequency
        -- Poll frequency bucket
        default {[ BPollFrequency.normal ]}
        
      address: String
        -- Address information about this point
        -- It will typically used in FlexMessageElements
        default {[ "" ]}
        
      address1: String
        -- Additional Address information about this point
        -- It will typically used in FlexMessageElements
        default {[ "" ]}
        
      address2: String
        -- Additional Address information about this point
        -- It will typically used in FlexMessageElements
        default {[ "" ]}
        
      pollMessage: BFlexRequestResponse
        -- This is a FlexRequestResponse message pair used to poll for point data.
        default {[ new BFlexRequestResponse() ]}
        
      writeMessage: BFlexRequestResponse
        -- Thhis is a FlexRequestResponse message pair used to write message data.
        default {[ new BFlexRequestResponse() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.point.BFlexProxyExt(2900654160)1.0$ @*/
/* Generated Fri Oct 14 10:37:54 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "pollFrequency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollFrequency</code> property.
   * Poll frequency bucket
   * @see com.tridium.flexSerial.point.BFlexProxyExt#getPollFrequency
   * @see com.tridium.flexSerial.point.BFlexProxyExt#setPollFrequency
   */
  public static final Property pollFrequency = newProperty(0, BPollFrequency.normal,null);
  
  /**
   * Get the <code>pollFrequency</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#pollFrequency
   */
  public BPollFrequency getPollFrequency() { return (BPollFrequency)get(pollFrequency); }
  
  /**
   * Set the <code>pollFrequency</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#pollFrequency
   */
  public void setPollFrequency(BPollFrequency v) { set(pollFrequency,v,null); }

////////////////////////////////////////////////////////////////
// Property "address"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address</code> property.
   * Address information about this point It will typically
   * used in FlexMessageElements
   * @see com.tridium.flexSerial.point.BFlexProxyExt#getAddress
   * @see com.tridium.flexSerial.point.BFlexProxyExt#setAddress
   */
  public static final Property address = newProperty(0, "",null);
  
  /**
   * Get the <code>address</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#address
   */
  public String getAddress() { return getString(address); }
  
  /**
   * Set the <code>address</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#address
   */
  public void setAddress(String v) { setString(address,v,null); }

////////////////////////////////////////////////////////////////
// Property "address1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address1</code> property.
   * Additional Address information about this point It
   * will typically used in FlexMessageElements
   * @see com.tridium.flexSerial.point.BFlexProxyExt#getAddress1
   * @see com.tridium.flexSerial.point.BFlexProxyExt#setAddress1
   */
  public static final Property address1 = newProperty(0, "",null);
  
  /**
   * Get the <code>address1</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#address1
   */
  public String getAddress1() { return getString(address1); }
  
  /**
   * Set the <code>address1</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#address1
   */
  public void setAddress1(String v) { setString(address1,v,null); }

////////////////////////////////////////////////////////////////
// Property "address2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address2</code> property.
   * Additional Address information about this point It
   * will typically used in FlexMessageElements
   * @see com.tridium.flexSerial.point.BFlexProxyExt#getAddress2
   * @see com.tridium.flexSerial.point.BFlexProxyExt#setAddress2
   */
  public static final Property address2 = newProperty(0, "",null);
  
  /**
   * Get the <code>address2</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#address2
   */
  public String getAddress2() { return getString(address2); }
  
  /**
   * Set the <code>address2</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#address2
   */
  public void setAddress2(String v) { setString(address2,v,null); }

////////////////////////////////////////////////////////////////
// Property "pollMessage"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollMessage</code> property.
   * This is a FlexRequestResponse message pair used to
   * poll for point data.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#getPollMessage
   * @see com.tridium.flexSerial.point.BFlexProxyExt#setPollMessage
   */
  public static final Property pollMessage = newProperty(0, new BFlexRequestResponse(),null);
  
  /**
   * Get the <code>pollMessage</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#pollMessage
   */
  public BFlexRequestResponse getPollMessage() { return (BFlexRequestResponse)get(pollMessage); }
  
  /**
   * Set the <code>pollMessage</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#pollMessage
   */
  public void setPollMessage(BFlexRequestResponse v) { set(pollMessage,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeMessage"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeMessage</code> property.
   * Thhis is a FlexRequestResponse message pair used to
   * write message data.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#getWriteMessage
   * @see com.tridium.flexSerial.point.BFlexProxyExt#setWriteMessage
   */
  public static final Property writeMessage = newProperty(0, new BFlexRequestResponse(),null);
  
  /**
   * Get the <code>writeMessage</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#writeMessage
   */
  public BFlexRequestResponse getWriteMessage() { return (BFlexRequestResponse)get(writeMessage); }
  
  /**
   * Set the <code>writeMessage</code> property.
   * @see com.tridium.flexSerial.point.BFlexProxyExt#writeMessage
   */
  public void setWriteMessage(BFlexRequestResponse v) { set(writeMessage,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get the network cast to a BFlexSerialNetwork.
   */
  public final BFlexSerialNetwork getFlexNetwork()
  {
    return (BFlexSerialNetwork)getNetwork();
  }

  /**
   * Get the device cast to a BFlexSerialDevice.
   */
  public final BFlexSerialDevice getFlexDevice()
  {
    return (BFlexSerialDevice)getDevice();
  }

  /**
   * Get the device address property value.
   */
  public final String getFlexDeviceAddress()
  {
    return ((BFlexSerialDevice)getDevice()).getAddress();
  }

  /**
   * Get the point device ext cast to a BFlexPointDeviceExt.
   */
  public final BFlexPointDeviceExt getFlexPointDeviceExt()
  {
    return (BFlexPointDeviceExt)getDeviceExt();
  }

////////////////////////////////////////////////////////////////
// ProxyExt
////////////////////////////////////////////////////////////////
  
  /**
   * Return the device type. 
   */
  public Type getDeviceExtType()
  {
    return BFlexPointDeviceExt.TYPE;
  }                     
  
  /**
   * Return if this proxy point is readonly, readWrite or writeonly.
   */
  public BReadWriteMode getMode()
  {
    if(getParentPoint().isWritablePoint())
      return getPollMessage().isRequestDefined() ? BReadWriteMode.readWrite : BReadWriteMode.writeonly;
    return BReadWriteMode.readonly; 
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if(slot.equals(readValue) || slot.equals(writeValue) )
       return getPointFacets();
    return super.getSlotFacets(slot);
  }


 /**
  * Override implementation of <code>BIBasicPollable</code>.
  * Causes communication to read the value of this point.
  */

 public void poll()
 {
  // If the parent point is out of service, or the parent
  // device is down, skip this poll.
  if ( isUnoperational() )
  {
   return;
  }
    
  BFlexSerialNetwork network = (BFlexSerialNetwork)getNetwork();
  if (network.getLog().isTraceOn()) network.getLog().trace(this + ".poll()");
      
  pollForData();
    network = null;
 }


 /**
  * This method will poll for data.
  */
 private void pollForData()
 {
   // do not poll if writeonly.
   if(getMode().equals(BReadWriteMode.writeonly))
   {
     readOk(getWriteValue());
     return;
   }
   BFlexRequestResponse pMessage = getPollMessage();
   String results = pMessage.sendMessage(null);
   //System.out.println("???????????????????? sendMessage results = " + results);
   if(results.equalsIgnoreCase("OK"))
   {
     try
     {
       if( ! getPollMessage().isResponseDefined() )
       {
         readFail("poll response message not defined!");
         return;
       }

       BStatusValue newStatusValue = decodeResponseStatusValue(pMessage.getResponse());
       if( newStatusValue != null )
       {
         readOk(newStatusValue);
         getDevice().pingOk();
       }
       else
       {
         readFail("unable to convert response");
       }
     }
     catch(Exception e)
     {
       e.printStackTrace();
       readFail(e.toString());
     }
   }
   else
   {
    if(results.equals("response timeout"))
      getDevice().pingFail(results);
    else
      readFail(results);
   }  
   
 }

  /**
   * This callback from asynchronous thread to send a write to the device.
   * Can be implemented by subclasses!
   *
   * @param BStatusValue out is the value to be sent to the foreign hardware
   */
  public void doWrite(BStatusValue value)
  {
    //System.out.println(" ~~~~~~~~~ doWrite callback with: " + value + " on point: " + getParentPoint().getName());
    //Thread.dumpStack();
    // If the parent point is out of service, or the parent
    // device is down, skip this write.
    if ( isUnoperational() )
    {
     return;
    }
    try
    {
      BFlexRequestResponse pMessage = getWriteMessage();
      String results = pMessage.sendMessage(null);
      //System.out.println("???????????????????? sendMessage results = " + results);
      if(results.equalsIgnoreCase("OK"))
      {
        if( ! getWriteMessage().isResponseDefined() )
        {
          writeOk(value);
          return;
        }
        try
        {
          BStatusValue newStatusValue = decodeResponseStatusValue(pMessage.getResponse());
          if( newStatusValue != null )
            writeOk(newStatusValue);
          else
            writeOk(value);
        }
        catch(Exception e)
        {
          e.printStackTrace();
          writeFail(e.toString());
        }
    
      }
      else
      {
        //System.out.println(" **** write fail with error: " + results);
        writeFail(results);
      }  
    }
    catch(Exception e)
    {
      e.printStackTrace();
      writeFail(e.toString());
    }
  }

  private BStatusValue decodeResponseStatusValue(BFlexResponseMessage rMessage)
  {
    BStatusValue newStatusValue = null;
    try
    {
      BFlexMessageBlock msgBlock = (BFlexMessageBlock)rMessage.get("instance");
      if(msgBlock == null)
      {
        rMessage.doCreateInstance();
        msgBlock = (BFlexMessageBlock)rMessage.get("instance");
      }
      
      BFlexMessageElement msgElement = msgBlock.getMessageElement(rMessage.getElementSelect().getElementSelect());
      if(msgElement == null)
        return null;
      //System.out.println("element value = " + msgElement.getValue());
      if(isNumeric())
      {
        newStatusValue = new BStatusNumeric( msgElement.getDoubleValue() );
      }
      else if(isBoolean())
      {
        newStatusValue = new BStatusBoolean( msgElement.getBooleanValue() );
      }
      else if(isString())
      {
        newStatusValue = new BStatusString( msgElement.getStringValue() );
      }
      else if(isEnum())
      {
        newStatusValue = new BStatusEnum( msgElement.getEnumValue() );
      }
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    return newStatusValue;
  }


  protected boolean isBoolean()
  {
  return getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
  }
  
  protected boolean isNumeric()
  {
  return getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
  }
  
  protected boolean isString()
  {
  return getParentPoint().getOutStatusValue() instanceof BStatusString;
  }
  
  protected boolean isEnum()
  {
  return getParentPoint().getOutStatusValue() instanceof BStatusEnum;
  }
  


}
