/** Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.flexSerial.BFlexSerialNetwork;

/**
 * BMessageSelect is a used to select a FlexMessages defined.
 *
 * @author    Andy Saunders
 * @creation  15 Sept 05
 * @version   $Revision:$ $Date: 4/6/2005 5:43:17 PM$
 * @since     Niagara 3.0
 */
public class BMessageSelect
  extends BComponent
{
  /*-
  
  class BMessageSelect
  {
    properties
    {
      message: String
        default {[ "" ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:MessageSelectFE")) ]}
        
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BMessageSelect(1813544921)1.0$ @*/
/* Generated Fri Sep 16 11:18:12 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "message"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>message</code> property.
   * @see com.tridium.flexSerial.messages.BMessageSelect#getMessage
   * @see com.tridium.flexSerial.messages.BMessageSelect#setMessage
   */
  public static final Property message = newProperty(0, "",BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:MessageSelectFE")) );
  
  /**
   * Get the <code>message</code> property.
   * @see com.tridium.flexSerial.messages.BMessageSelect#message
   */
  public String getMessage() { return getString(message); }
  
  /**
   * Set the <code>message</code> property.
   * @see com.tridium.flexSerial.messages.BMessageSelect#message
   */
  public void setMessage(String v) { setString(message,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMessageSelect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  public static BFlexMessage getFlexMessage(BComplex base, String message)
  {
    BFlexSerialNetwork service = BFlexSerialNetwork.getParentFlexNetwork(base);
    BFlexMessageFolder messageFolder = service.getMessages();
    BFlexMessage[] messages = messageFolder.getChildren(BFlexMessage.class);
    for(int i = 0; i < messages.length; i++)
    {
      if(messages[i].getName().equals(message) )
        return messages[i];
    }
    return null;
  }

}
