/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.util.*;
import javax.baja.naming.*;

import com.tridium.program.*;

import com.tridium.flexSerial.*;
import com.tridium.flexSerial.enums.*;
import com.tridium.flexSerial.messages.*;

/**
 * BFlexUnsolicitedMessage defines a final message.
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2005
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BFlexUnsolicitedMessage
  extends BFlexResponseMessage
{ 
  public static final Property byteArray = newProperty(Flags.TRANSIENT, BBlob.DEFAULT,BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:FlexBlobFE")) ) ;

  /*-
  
  class BFlexUnsolicitedMessage
  {
    properties
    {
      timestamp: BAbsTime
        -- time stamp of last received data
        default{[ BAbsTime.NULL ]}
    }

    topics
    {
      unsolicitedMessageReceived: BValue
    }


    actions
    {
      
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BFlexUnsolicitedMessage(8681519)1.0$ @*/
/* Generated Wed Jan 03 12:54:20 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "timestamp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timestamp</code> property.
   * time stamp of last received data
   * @see com.tridium.flexSerial.messages.BFlexUnsolicitedMessage#getTimestamp
   * @see com.tridium.flexSerial.messages.BFlexUnsolicitedMessage#setTimestamp
   */
  public static final Property timestamp = newProperty(0, BAbsTime.NULL,null);
  
  /**
   * Get the <code>timestamp</code> property.
   * @see com.tridium.flexSerial.messages.BFlexUnsolicitedMessage#timestamp
   */
  public BAbsTime getTimestamp() { return (BAbsTime)get(timestamp); }
  
  /**
   * Set the <code>timestamp</code> property.
   * @see com.tridium.flexSerial.messages.BFlexUnsolicitedMessage#timestamp
   */
  public void setTimestamp(BAbsTime v) { set(timestamp,v,null); }

////////////////////////////////////////////////////////////////
// Topic "unsolicitedMessageReceived"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unsolicitedMessageReceived</code> topic.
   * @see com.tridium.flexSerial.messages.BFlexUnsolicitedMessage#fireUnsolicitedMessageReceived
   */
  public static final Topic unsolicitedMessageReceived = newTopic(0,null);
  
  /**
   * Fire an event for the <code>unsolicitedMessageReceived</code> topic.
   * @see com.tridium.flexSerial.messages.BFlexUnsolicitedMessage#unsolicitedMessageReceived
   */
  public void fireUnsolicitedMessageReceived(BValue event) { fire(unsolicitedMessageReceived, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexUnsolicitedMessage.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context cx)
  {
    super.changed(p,cx);
    if(!isRunning())
      return;
    if(p.equals(byteArray))
    {
      BOrd errorCheckOrd = getMessageValidate();
      if(!errorCheckOrd.equals(BOrd.NULL))
      {
        BObject obj = errorCheckOrd.get(this);
        if(obj instanceof BProgram)
        {
          try
          {
            BProgram errorCheckPgm = (BProgram)obj;
            errorCheckPgm.set("responseByteArray", getByteArray().newCopy());
            errorCheckPgm.doExecute();
            BValue results = errorCheckPgm.get("results");
            String error = ((BString)results).getString();
            if(error == null || error.length() ==0)
            {
              return;
            }
            if(! error.equalsIgnoreCase("OK"))
              return;
          }
          catch(Exception e)
          {
            return;
          }

        }
      }
      // we have received a valid message
      try
      {
        BFlexMessageBlock instance = (BFlexMessageBlock)get("instance");
        if(instance == null)
        {
          this.doCreateInstance();
        }
        instance = (BFlexMessageBlock)get("instance");
        if(instance == null)
           return;
        instance.readFrom(this, new FlexInputStream(this.getByteArray().copyBytes()));
        setTimestamp(Clock.time());
        fireUnsolicitedMessageReceived(null);
      }
      catch(Exception e) 
      {
        e.printStackTrace();
      }

    }
  }
////////////////////////////////////////////////////////////////
//Presentation
////////////////////////////////////////////////////////////////

 public BIcon getIcon() { return icon; }
 private static final BIcon icon = BIcon.make("module://flexSerial/com/tridium/flexSerial/icons/flexMessageUnsolicited.png");



}
