/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.util.*;
import javax.baja.naming.*;

import com.tridium.program.*;

import com.tridium.flexSerial.*;
import com.tridium.flexSerial.enums.*;
import com.tridium.flexSerial.messages.*;

/**
 * BFlexSendMessage defines a final message.
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2005
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BFlexSendMessage
  extends BFlexRequestMessage
{ 

  /*-
  
  class BFlexSendMessage
  {
    properties
    {
      enable: BStatusBoolean
        default{[ new BStatusBoolean(true) ]}
      faultCause: String
        flags{ transient, readonly }
        default{[ "" ]}
        
      timestamp: BAbsTime
        -- time stamp of last received data
        flags{ transient, readonly }
        default{[ BAbsTime.NULL ]}
    }

    actions
    {
      send()
        flags{ async }
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BFlexSendMessage(2079329090)1.0$ @*/
/* Generated Wed Jan 03 14:17:28 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "enable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enable</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#getEnable
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#setEnable
   */
  public static final Property enable = newProperty(0, new BStatusBoolean(true),null);
  
  /**
   * Get the <code>enable</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#enable
   */
  public BStatusBoolean getEnable() { return (BStatusBoolean)get(enable); }
  
  /**
   * Set the <code>enable</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#enable
   */
  public void setEnable(BStatusBoolean v) { set(enable,v,null); }

////////////////////////////////////////////////////////////////
// Property "faultCause"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>faultCause</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#getFaultCause
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#setFaultCause
   */
  public static final Property faultCause = newProperty(Flags.TRANSIENT|Flags.READONLY, "",null);
  
  /**
   * Get the <code>faultCause</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#faultCause
   */
  public String getFaultCause() { return getString(faultCause); }
  
  /**
   * Set the <code>faultCause</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#faultCause
   */
  public void setFaultCause(String v) { setString(faultCause,v,null); }

////////////////////////////////////////////////////////////////
// Property "timestamp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timestamp</code> property.
   * time stamp of last received data
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#getTimestamp
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#setTimestamp
   */
  public static final Property timestamp = newProperty(Flags.TRANSIENT|Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>timestamp</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#timestamp
   */
  public BAbsTime getTimestamp() { return (BAbsTime)get(timestamp); }
  
  /**
   * Set the <code>timestamp</code> property.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#timestamp
   */
  public void setTimestamp(BAbsTime v) { set(timestamp,v,null); }

////////////////////////////////////////////////////////////////
// Action "send"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>send</code> action.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#send()
   */
  public static final Action send = newAction(Flags.ASYNC,null);
  
  /**
   * Invoke the <code>send</code> action.
   * @see com.tridium.flexSerial.messages.BFlexSendMessage#send
   */
  public void send() { invoke(send,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexSendMessage.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

  public void doSend()
  {
    if(! getEnable().getBoolean())
    {
      return;
    }
    BFlexMessageBlock msg = (BFlexMessageBlock)this.get("instance");
    if(msg == null)
      this.doCreateInstance();
    msg = (BFlexMessageBlock)this.get("instance");
    if(msg == null)
    {
      setFaultCause("RequestMessage instance not found.");
      return;
    }
    BComplex parent = getParent();
    if( parent == null || !(parent instanceof BFlexSerialNetwork))
    {
      setFaultCause("Parent not a flex serial network.");
      return;
    }
    BFlexSerialNetwork network = (BFlexSerialNetwork)parent; 
    FlexOutputStream out = new FlexOutputStream();
    msg.writeTo(this, out);
    this.setByteArray(BBlob.make(out.toByteArray()));
    SerialMessage sendReq = new SerialMessage(out.toByteArray());
    sendReq.setResponseExpected(false);
    network.sendSync(sendReq);
    setFaultCause("");
    setTimestamp(Clock.time());
    
  }
  
  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if(!isRunning())
      return;
  }

}
