/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.nre.util.*;
import javax.baja.util.*;
import com.tridium.program.*;

import com.tridium.flexSerial.*;
import com.tridium.flexSerial.enums.*;
import com.tridium.flexSerial.messages.*;

/**
 * BFlexMessageSelect defines a final message.
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2005
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BFlexMessageSelect
  extends BComponent
{

  /*-

  class BFlexMessageSelect
  {
    properties
    {
      message: BFlexMessageName
        default {[ new BFlexMessageName() ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:MessageSelectFE")) ]}

      facets: BFacets
        default {[ BFacets.NULL ]}

      byteArray: BBlob
        flags { transient, readonly }
        default {[ BBlob.DEFAULT ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:FlexBlobFE")) ]}

    }

    actions
    {
      --createInstance()
      --makeByteArray()
      showInstance()
        flags { hidden }
      hideInstance()
        flags { hidden }
    }

  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BFlexMessageSelect(2738863583)1.0$ @*/
/* Generated Thu Jan 04 10:02:13 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "message"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>message</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#getMessage
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#setMessage
   */
  public static final Property message = newProperty(0, new BFlexMessageName(),BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:MessageSelectFE")) );

  /**
   * Get the <code>message</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#message
   */
  public BFlexMessageName getMessage() { return (BFlexMessageName)get(message); }

  /**
   * Set the <code>message</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#message
   */
  public void setMessage(BFlexMessageName v) { set(message,v,null); }

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>facets</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#getFacets
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.NULL,null);

  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }

  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "byteArray"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>byteArray</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#getByteArray
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#setByteArray
   */
  public static final Property byteArray = newProperty(Flags.TRANSIENT|Flags.READONLY, BBlob.DEFAULT,BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:FlexBlobFE")) );

  /**
   * Get the <code>byteArray</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#byteArray
   */
  public BBlob getByteArray() { return (BBlob)get(byteArray); }

  /**
   * Set the <code>byteArray</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#byteArray
   */
  public void setByteArray(BBlob v) { set(byteArray,v,null); }

////////////////////////////////////////////////////////////////
// Action "showInstance"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>showInstance</code> action.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#showInstance()
   */
  public static final Action showInstance = newAction(Flags.HIDDEN,null);

  /**
   * Invoke the <code>showInstance</code> action.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#showInstance
   */
  public void showInstance() { invoke(showInstance,null,null); }

////////////////////////////////////////////////////////////////
// Action "hideInstance"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>hideInstance</code> action.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#hideInstance()
   */
  public static final Action hideInstance = newAction(Flags.HIDDEN,null);

  /**
   * Invoke the <code>hideInstance</code> action.
   * @see com.tridium.flexSerial.messages.BFlexMessageSelect#hideInstance
   */
  public void hideInstance() { invoke(hideInstance,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexMessageSelect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////

  public void doShowInstance()
  {
    try
    {
      Slot instanceSlot = this.getSlot("instance");
      if(instanceSlot == null)
      {
        this.setFlags(showInstance, getFlags(showInstance) | Flags.HIDDEN);
        this.setFlags(hideInstance, getFlags(hideInstance) | Flags.HIDDEN);
        return;
      }
      this.setFlags(instanceSlot, this.getFlags(instanceSlot) & ~Flags.HIDDEN);
      this.setFlags(showInstance, getFlags(showInstance) |  Flags.HIDDEN);
      this.setFlags(hideInstance, getFlags(hideInstance) & ~Flags.HIDDEN);

    }
    catch(Exception e){ e.printStackTrace(); }
  }

  public void doHideInstance()
  {
    try
    {
      Slot instanceSlot = this.getSlot("instance");
      if(instanceSlot == null)
      {
        this.setFlags(showInstance, getFlags(showInstance) | Flags.HIDDEN);
        this.setFlags(hideInstance, getFlags(hideInstance) | Flags.HIDDEN);
        return;
      }
      this.setFlags(instanceSlot, this.getFlags(instanceSlot) | Flags.HIDDEN);
      this.setFlags(showInstance, getFlags(showInstance) & ~Flags.HIDDEN);
      this.setFlags(hideInstance, getFlags(hideInstance) |  Flags.HIDDEN);
    }
    catch(Exception e){ e.printStackTrace(); }
  }

  public void doCreateInstance()
  {
    BFlexMessage reqMsg = BMessageSelect.getFlexMessage(this, getMessage().getMessageSelect());
    if(reqMsg == null)
      return;
    try { this.remove("instance"); } catch(Exception e) {}
    this.add("instance", new BFlexMessageBlock(), Flags.HIDDEN | Flags.TRANSIENT);
    BFlexMessageBlock instance = (BFlexMessageBlock)get("instance");
    reqMsg.addMessageItems(instance);
    instance.doCalculateOffsets();
    instance.exposeInParent();
    this.setFlags(showInstance, getFlags(showInstance) & ~Flags.HIDDEN);
    this.setFlags(hideInstance, getFlags(hideInstance) |  Flags.HIDDEN);

  }

  public void doMakeByteArray()
  {
    BFlexMessage reqMsg = BMessageSelect.getFlexMessage(this, getMessage().getMessageSelect());
    BFlexMessageBlock instance = (BFlexMessageBlock)get("instance");
    FlexOutputStream out = new FlexOutputStream();
    instance.writeTo(this, out);
    //System.out.println(ByteArrayUtil.toHexString(out.toByteArray()));

  }

  public void changed(Property p, Context cx)
  {
    if(!isRunning() )
      return;
    if(cx != null && cx.equals(Context.decoding) )
      return;
    if(p.equals(message))
    {
      if(getMessage().getMessageSelect().length() == 0)
        try { this.remove("instance"); } catch(Exception e) {}
      else
        doCreateInstance();
    }
  }

  public BFacets getSlotFacets(Slot slot)
  {
    BFacets facets = super.getSlotFacets(slot);
    if(slot.equals(byteArray))
    {
      return BFacets.make(facets, getFacets());
    }
    return facets;
  }

  public String toString(Context cx)
  {

    if( ! getFacets().getb(BFlexMessageElement.SHOW_ASCII, false))
      return ByteArrayUtil.toHexString( getByteArray().copyBytes());
    else
      return new String(getByteArray().copyBytes());
  }

////////////////////////////////////////////////////////////////
//Presentation
////////////////////////////////////////////////////////////////

 public BIcon getIcon() { return icon; }
 private static final BIcon icon = BIcon.make("module://flexSerial/com/tridium/flexSerial/icons/flexMessage.png");


}
