/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BFlexMessageBlock defines a collection of message items.
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2005
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BFlexMessageBlock
  extends BComponent
  implements BIFlexMessageBlock
{ 

  /*-
  
  class BFlexMessageBlock
  {
    properties
    {
    
      description: String
        default{[ "" ]}
        
      size: int
        flags{ readonly }
        default{[ 0 ]}
        
    }
    
    
    actions
    {
      calculateOffsets()
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BFlexMessageBlock(2133466096)1.0$ @*/
/* Generated Tue Feb 13 10:03:25 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "description"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>description</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#getDescription
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#setDescription
   */
  public static final Property description = newProperty(0, "",null);
  
  /**
   * Get the <code>description</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#description
   */
  public String getDescription() { return getString(description); }
  
  /**
   * Set the <code>description</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#description
   */
  public void setDescription(String v) { setString(description,v,null); }

////////////////////////////////////////////////////////////////
// Property "size"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>size</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#getSize
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#setSize
   */
  public static final Property size = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>size</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#size
   */
  public int getSize() { return getInt(size); }
  
  /**
   * Set the <code>size</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#size
   */
  public void setSize(int v) { setInt(size,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculateOffsets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculateOffsets</code> action.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#calculateOffsets()
   */
  public static final Action calculateOffsets = newAction(0,null);
  
  /**
   * Invoke the <code>calculateOffsets</code> action.
   * @see com.tridium.flexSerial.messages.BFlexMessageBlock#calculateOffsets
   */
  public void calculateOffsets() { invoke(calculateOffsets,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexMessageBlock.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context cx)
  {
    if(!isRunning())
      return;
    Property pip = getPropertyInParent();
    // force a change on parent BFlexMessageBlockFolder if this is frameEnd
    // or frameStart.
    if(pip != null && ( pip.equals(BFlexMessageBlockFolder.frameEnd) ||
                        pip.equals(BFlexMessageBlockFolder.frameStart)   ) )
    {
      ((BComponent)getParent()).changed(BFlexMessageBlockFolder.frameStart, cx);
    }
  }
  
  public void added(Property property, Context context)
  {
    calculateItemOffsets();
    super.added(property, context);
  }

  
  public void removed(Property property, BValue oldValue, Context context)
  {
    calculateItemOffsets();
    super.removed(property, oldValue, context);
  }

  
  public void doCalculateOffsets()
  {
    calculateItemOffsets();
  }

  public void calculateItemOffsets()
  {
    BFlexMessageElement[] items = getChildren(BFlexMessageElement.class);
    int offset = 0;
    int size = 0;
    for(int i = 0; i < items.length; i++)
    {
      items[i].setOffset(offset);
      offset = offset + items[i].getSize();
      size = size + items[i].getSize();
    }
    setSize(size);
  }

  public void exposeInParent()
  {
    BFlexMessageElement[] items = getChildren(BFlexMessageElement.class);
    for(int i = 0; i < items.length; i++)
    {
      items[i].exposeInParent();
    }
  }

  public void writeTo(BObject baseObj, FlexOutputStream out)
  {
    //System.out.println("BFlexMessageBlock.writeTo(): " + this.getName());
    BIFlexMessageElement[] items = getChildren(BIFlexMessageElement.class);
    for(int i = 0; i < items.length; i++)
    {
      items[i].writeTo(baseObj, out);
    }
  }

  public void readFrom(BObject baseObj, FlexInputStream out)
  {
    //System.out.println("BFlexMessageBlock.readFrom(): " + this.getName());
    BIFlexMessageElement[] items = getChildren(BIFlexMessageElement.class);
    for(int i = 0; i < items.length; i++)
    {
      items[i].readFrom(baseObj, out);
    }
  }

  public byte[] getByteArray()
  {
    FlexOutputStream out = new FlexOutputStream();
    writeTo(this, out);
    return out.toByteArray();
  }

  public int getMarker(String markerName)
  {
    System.out.println("BFlexMessageBlock.getMarker(): " + this.getName());
    BIFlexMessageElement[] items = getChildren(BIFlexMessageElement.class);
    for(int i = 0; i < items.length; i++)
    {
      if( items[i].getMarker(markerName) >= 0 )
        return items[i].getOffset();
    }
    return -1;
  }

  public void addMessageItems(BFlexMessageBlock parent)
  {
    //System.out.println("BFlexMessageBlock.addMessageItems(): " + this.getName());
    BIFlexMessageElement[] items = getChildren(BIFlexMessageElement.class);
    for(int i = 0; i < items.length; i++)
    {
      if(items[i] instanceof BIFlexMessageBlock)                                                         
        ((BIFlexMessageBlock)items[i]).addMessageItems(parent);
      else
        parent.add(((BComplex)items[i]).getName() + "?", ((BComplex)items[i]).newCopy());
    }
  }
  
  public BFlexMessageElement getMessageElement(String name)
  {
    //System.out.println("BFlexMessageBlock.getMessageElement(): " + this.getName());
    BFlexMessageElement[] items = getChildren(BFlexMessageElement.class);
    for(int i = 0; i < items.length; i++)
    {
      if( items[i].getName().equals(name) )
        return items[i];
    }
    return null;
  }


  public int getOffset()
  {
    return 0;
  }
  
////////////////////////////////////////////////////////////////
//Presentation
////////////////////////////////////////////////////////////////

 public BIcon getIcon() { return icon; }
 private static final BIcon icon = BIcon.make("module://flexSerial/com/tridium/flexSerial/icons/flexMessageBlock.png");

  
}
