/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.flexSerial.enums.BDataTypeEnum;

/**
 * BFlexFloatElement defines a primitive message element.  
 * <P>The purpose of the FlexMessageElement is to completely define a primitive element
 * of a message.  It contain enough information to serialize this element value to and 
 * from a native byte array.  The FlexSerial driver provides a special view and editor 
 * that can be used to create FlexMessageElements.</P>
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2005
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BFlexByteElement
  extends BFlexMessageElement
  implements BIFlexMessageElement
{ 

  /*-
  
  class BFlexByteElement
  {
    properties
    {
      dataType: BDataTypeEnum
        flags { readonly }
        -- Specifies that this is a byte data type.
        default {[ BDataTypeEnum.Byte ]}
        
      value: BValue
        -- This is the value of this message element and is dependent on the dataType
        -- specified.  This value can be a constant or can be a "indirect" value from 
        -- the object defined in the source property.
        default {[ BInteger.make(0) ]}
        
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BFlexByteElement(1512517411)1.0$ @*/
/* Generated Tue Dec 05 14:58:27 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "dataType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>dataType</code> property.
   * @see com.tridium.flexSerial.messages.BFlexByteElement#getDataType
   * @see com.tridium.flexSerial.messages.BFlexByteElement#setDataType
   */
  public static final Property dataType = newProperty(Flags.READONLY, BDataTypeEnum.Byte,null);
  
  /**
   * Get the <code>dataType</code> property.
   * @see com.tridium.flexSerial.messages.BFlexByteElement#dataType
   */
  public BDataTypeEnum getDataType() { return (BDataTypeEnum)get(dataType); }
  
  /**
   * Set the <code>dataType</code> property.
   * @see com.tridium.flexSerial.messages.BFlexByteElement#dataType
   */
  public void setDataType(BDataTypeEnum v) { set(dataType,v,null); }

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * This is the value of this message element and is dependent
   * on the dataType specified.  This value can be a constant
   * or can be a "indirect" value from the object defined
   * in the source property.
   * @see com.tridium.flexSerial.messages.BFlexByteElement#getValue
   * @see com.tridium.flexSerial.messages.BFlexByteElement#setValue
   */
  public static final Property value = newProperty(0, BInteger.make(0),null);
  
  /**
   * Get the <code>value</code> property.
   * @see com.tridium.flexSerial.messages.BFlexByteElement#value
   */
  public BValue getValue() { return get(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see com.tridium.flexSerial.messages.BFlexByteElement#value
   */
  public void setValue(BValue v) { set(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexByteElement.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////


}
