/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

import com.tridium.flexSerial.*;
import com.tridium.flexSerial.messages.*;

/**
 * BSerialRequest will send a request and expose the response
 *
 * @author    Andy Saunders
 * @creation  16 April 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BSerialRequest
  extends BComponent
{ 

  /*-
  
  class BSerialRequest
  {
    properties
    {
      request: BStatusString
        -- The intput is a request string.
        flags { operator, summary }
        default {[ new BStatusString("") ]}
 
      addFrameStart: boolean
        -- If true start framing will automatically be added
        default {[ true ]}
         
      addFrameEnd: boolean
        -- If true end framing will automatically be added
        default {[ true ]}
         
      response: BStatusString
        -- The reply to the response
        flags { operator, summary }
        default {[ new BStatusString("") ]}
        
      responseExpected: boolean
        default {[ true ]}
        
      stripFrameStart: boolean
        -- If true start framing will automatically be removed
        default {[ true ]}
         
      stripFrameEnd: boolean
        -- If true end framing will automatically be removed
        default {[ true ]}
         
        
    }
    
    actions
    {
      sendRequest()
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.BSerialRequest(1547846181)1.0$ @*/
/* Generated Thu Jan 04 10:31:48 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "request"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>request</code> property.
   * The intput is a request string.
   * @see com.tridium.flexSerial.BSerialRequest#getRequest
   * @see com.tridium.flexSerial.BSerialRequest#setRequest
   */
  public static final Property request = newProperty(Flags.OPERATOR|Flags.SUMMARY, new BStatusString(""),null);
  
  /**
   * Get the <code>request</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#request
   */
  public BStatusString getRequest() { return (BStatusString)get(request); }
  
  /**
   * Set the <code>request</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#request
   */
  public void setRequest(BStatusString v) { set(request,v,null); }

////////////////////////////////////////////////////////////////
// Property "addFrameStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addFrameStart</code> property.
   * If true start framing will automatically be added
   * @see com.tridium.flexSerial.BSerialRequest#getAddFrameStart
   * @see com.tridium.flexSerial.BSerialRequest#setAddFrameStart
   */
  public static final Property addFrameStart = newProperty(0, true,null);
  
  /**
   * Get the <code>addFrameStart</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#addFrameStart
   */
  public boolean getAddFrameStart() { return getBoolean(addFrameStart); }
  
  /**
   * Set the <code>addFrameStart</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#addFrameStart
   */
  public void setAddFrameStart(boolean v) { setBoolean(addFrameStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "addFrameEnd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addFrameEnd</code> property.
   * If true end framing will automatically be added
   * @see com.tridium.flexSerial.BSerialRequest#getAddFrameEnd
   * @see com.tridium.flexSerial.BSerialRequest#setAddFrameEnd
   */
  public static final Property addFrameEnd = newProperty(0, true,null);
  
  /**
   * Get the <code>addFrameEnd</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#addFrameEnd
   */
  public boolean getAddFrameEnd() { return getBoolean(addFrameEnd); }
  
  /**
   * Set the <code>addFrameEnd</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#addFrameEnd
   */
  public void setAddFrameEnd(boolean v) { setBoolean(addFrameEnd,v,null); }

////////////////////////////////////////////////////////////////
// Property "response"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>response</code> property.
   * The reply to the response
   * @see com.tridium.flexSerial.BSerialRequest#getResponse
   * @see com.tridium.flexSerial.BSerialRequest#setResponse
   */
  public static final Property response = newProperty(Flags.OPERATOR|Flags.SUMMARY, new BStatusString(""),null);
  
  /**
   * Get the <code>response</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#response
   */
  public BStatusString getResponse() { return (BStatusString)get(response); }
  
  /**
   * Set the <code>response</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#response
   */
  public void setResponse(BStatusString v) { set(response,v,null); }

////////////////////////////////////////////////////////////////
// Property "responseExpected"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>responseExpected</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#getResponseExpected
   * @see com.tridium.flexSerial.BSerialRequest#setResponseExpected
   */
  public static final Property responseExpected = newProperty(0, true,null);
  
  /**
   * Get the <code>responseExpected</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#responseExpected
   */
  public boolean getResponseExpected() { return getBoolean(responseExpected); }
  
  /**
   * Set the <code>responseExpected</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#responseExpected
   */
  public void setResponseExpected(boolean v) { setBoolean(responseExpected,v,null); }

////////////////////////////////////////////////////////////////
// Property "stripFrameStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stripFrameStart</code> property.
   * If true start framing will automatically be removed
   * @see com.tridium.flexSerial.BSerialRequest#getStripFrameStart
   * @see com.tridium.flexSerial.BSerialRequest#setStripFrameStart
   */
  public static final Property stripFrameStart = newProperty(0, true,null);
  
  /**
   * Get the <code>stripFrameStart</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#stripFrameStart
   */
  public boolean getStripFrameStart() { return getBoolean(stripFrameStart); }
  
  /**
   * Set the <code>stripFrameStart</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#stripFrameStart
   */
  public void setStripFrameStart(boolean v) { setBoolean(stripFrameStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "stripFrameEnd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stripFrameEnd</code> property.
   * If true end framing will automatically be removed
   * @see com.tridium.flexSerial.BSerialRequest#getStripFrameEnd
   * @see com.tridium.flexSerial.BSerialRequest#setStripFrameEnd
   */
  public static final Property stripFrameEnd = newProperty(0, true,null);
  
  /**
   * Get the <code>stripFrameEnd</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#stripFrameEnd
   */
  public boolean getStripFrameEnd() { return getBoolean(stripFrameEnd); }
  
  /**
   * Set the <code>stripFrameEnd</code> property.
   * @see com.tridium.flexSerial.BSerialRequest#stripFrameEnd
   */
  public void setStripFrameEnd(boolean v) { setBoolean(stripFrameEnd,v,null); }

////////////////////////////////////////////////////////////////
// Action "sendRequest"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sendRequest</code> action.
   * @see com.tridium.flexSerial.BSerialRequest#sendRequest()
   */
  public static final Action sendRequest = newAction(0,null);
  
  /**
   * Invoke the <code>sendRequest</code> action.
   * @see com.tridium.flexSerial.BSerialRequest#sendRequest
   */
  public void sendRequest() { invoke(sendRequest,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSerialRequest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  public void started()
  {
    network = getNetwork();
  }

  public void changed(Property property, Context context) 
  {
    if(isRunning())
    {
      if(property == request) doSendRequest();
    }
  }

  public void doSendRequest()
  {
    if(getNetwork() == null)
      return;
    String frameStart = new String(network.getMessageBlocks().getFrameStart().getByteArray());
    String frameEnd = new String(network.getMessageBlocks().getFrameEnd().getByteArray());
    String reqData = getRequest().getValue();
    if(getAddFrameStart())
    {
      reqData = frameStart + reqData;
    }
    if(getAddFrameEnd())
    {
      reqData = reqData + frameEnd;
    }
    SerialMessage req = new SerialMessage(reqData);
    boolean isResponseExpected = getResponseExpected();
    req.setResponseExpected(isResponseExpected);
    if(isResponseExpected)
    {
      SerialResponse resp;
      resp = (SerialResponse)network.sendSync(req);
      if(resp == null)
        System.out.println(" null response received");
      if(resp != null && resp.getBytes() != null)
      {
        String respString = new String(resp.getBytes());
        if(getStripFrameStart())
        {
          if(respString.startsWith(frameStart))
          {
            respString = respString.substring(frameStart.length());
          }
        }
        if(getStripFrameEnd())
        {
          if(respString.endsWith(frameEnd))
          {
            respString = respString.substring(0,respString.length() - frameEnd.length());
          }
        }
        getResponse().setValue(respString);
        getResponse().setStatusDown(false);
      }
      else
        getResponse().setStatusDown(true);
    }
    else
    {
      network.sendSync(req);
      setResponse(nre);
    }
  }

  BFlexSerialNetwork getNetwork()
  {
    if(network != null) return network;
    BComplex parent = this.getParent();
    while(parent != null)
    {
      if(parent instanceof BFlexSerialNetwork)
      {
        network = (BFlexSerialNetwork)parent;
        return network;
      }
      parent = parent.getParent();
    }
    return null;
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");
  */

////////////////////////////////////////////////////////////////
// attributes
////////////////////////////////////////////////////////////////  
  BFlexSerialNetwork network;
  static BStatusString nre = new BStatusString("Response Not Expected");

}
