/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.nav.*;
import javax.baja.nre.util.*;
import javax.baja.util.*;
import javax.baja.driver.util.*;
import javax.baja.license.*;

import com.tridium.basicdriver.serial.*;
import com.tridium.basicdriver.comm.*;

import com.tridium.flexSerial.comm.*;
import com.tridium.flexSerial.messages.*;

/**
 * BFlexSerialNetwork is the base container for a serial network.  It contains the infrastructure
 * requried to communicate to one or more serially connected devices.
 *
 * @author    Andy Saunders
 * @creation  22 April 2004
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BFlexSerialNetwork
  extends BSerialNetwork
{
  /*-
  class BFlexSerialNetwork
  {
    properties
    {
      --sendMessageSetup: BMessageDef
        -- This property is used to define message framing for messages being
        -- sent to a serial connected device.  The message framing defined will
        -- automatically be added to messages being sent out the serial port.
        --default {[ new BMessageDef() ]}

      --receiveMessageSetup: BMessageDef
        -- This property is used to define message framing for messages being
        -- received from a serial connected device.
        --default {[ new BMessageDef() ]}

      --stripReceiveFraming: boolean
        -- Set to true to enable the received message framing to be stripped
        -- as it is received.
        --default {[ true ]}

      maxReceiveSilentTime: int
        -- Defines the maximum number of milliseconds that the serial receive can be silent
        -- once receive data has started.  Typically used with protocols whose packet framing
        -- is defined by silent time.  A value of 0 will cause no timing to be done.
        default {[ 0 ]}

      unsolicitedMessage: BStatusString
        -- When an unsolicited message is received it will be set in this property.
        flags { transient, readonly }
        default {[ new BStatusString() ]}

      unsolicitedByteArray: BBlob
        flags { transient }
        default {[ BBlob.DEFAULT ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:FlexBlobFE")) ]}

      messageBlocks: BFlexMessageBlockFolder
        -- This is a special folder to contain user defined FlexMessageBlocks.
        -- FlexMessageBlocks are a collection of one or more FlexMessageElements.
        default {[ new BFlexMessageBlockFolder() ]}

      messages: BFlexMessageFolder
        -- This is a special folder to conatin user defined FlexMessages.
        -- A FlexMessage is a collection of FlexMessageBlock references and
        -- FlexMessageElements used to model a native device message.
        default {[ new BFlexMessageFolder() ]}

      initMessage: BFlexRequestResponse
        default {[ new BFlexRequestResponse() ]}

    }

    topics
    {
      unsolicitedMessageReceived: BValue
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.BFlexSerialNetwork(428596616)1.0$ @*/
/* Generated Thu Dec 07 16:16:46 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "maxReceiveSilentTime"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxReceiveSilentTime</code> property.
   * Defines the maximum number of milliseconds that the
   * serial receive can be silent once receive data has
   * started.  Typically used with protocols whose packet
   * framing is defined by silent time.  A value of 0 will
   * cause no timing to be done.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#getMaxReceiveSilentTime
   * @see com.tridium.flexSerial.BFlexSerialNetwork#setMaxReceiveSilentTime
   */
  public static final Property maxReceiveSilentTime = newProperty(0, 0,null);

  /**
   * Get the <code>maxReceiveSilentTime</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#maxReceiveSilentTime
   */
  public int getMaxReceiveSilentTime() { return getInt(maxReceiveSilentTime); }

  /**
   * Set the <code>maxReceiveSilentTime</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#maxReceiveSilentTime
   */
  public void setMaxReceiveSilentTime(int v) { setInt(maxReceiveSilentTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "unsolicitedMessage"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>unsolicitedMessage</code> property.
   * When an unsolicited message is received it will be
   * set in this property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#getUnsolicitedMessage
   * @see com.tridium.flexSerial.BFlexSerialNetwork#setUnsolicitedMessage
   */
  public static final Property unsolicitedMessage = newProperty(Flags.TRANSIENT|Flags.READONLY, new BStatusString(),null);

  /**
   * Get the <code>unsolicitedMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#unsolicitedMessage
   */
  public BStatusString getUnsolicitedMessage() { return (BStatusString)get(unsolicitedMessage); }

  /**
   * Set the <code>unsolicitedMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#unsolicitedMessage
   */
  public void setUnsolicitedMessage(BStatusString v) { set(unsolicitedMessage,v,null); }

////////////////////////////////////////////////////////////////
// Property "unsolicitedByteArray"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>unsolicitedByteArray</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#getUnsolicitedByteArray
   * @see com.tridium.flexSerial.BFlexSerialNetwork#setUnsolicitedByteArray
   */
  public static final Property unsolicitedByteArray = newProperty(Flags.TRANSIENT, BBlob.DEFAULT,BFacets.make(BFacets.FIELD_EDITOR, BString.make("flexSerial:FlexBlobFE")) );

  /**
   * Get the <code>unsolicitedByteArray</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#unsolicitedByteArray
   */
  public BBlob getUnsolicitedByteArray() { return (BBlob)get(unsolicitedByteArray); }

  /**
   * Set the <code>unsolicitedByteArray</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#unsolicitedByteArray
   */
  public void setUnsolicitedByteArray(BBlob v) { set(unsolicitedByteArray,v,null); }

////////////////////////////////////////////////////////////////
// Property "messageBlocks"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>messageBlocks</code> property.
   * This is a special folder to contain user defined FlexMessageBlocks.
   * FlexMessageBlocks are a collection of one or more FlexMessageElements.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#getMessageBlocks
   * @see com.tridium.flexSerial.BFlexSerialNetwork#setMessageBlocks
   */
  public static final Property messageBlocks = newProperty(0, new BFlexMessageBlockFolder(),null);

  /**
   * Get the <code>messageBlocks</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#messageBlocks
   */
  public BFlexMessageBlockFolder getMessageBlocks() { return (BFlexMessageBlockFolder)get(messageBlocks); }

  /**
   * Set the <code>messageBlocks</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#messageBlocks
   */
  public void setMessageBlocks(BFlexMessageBlockFolder v) { set(messageBlocks,v,null); }

////////////////////////////////////////////////////////////////
// Property "messages"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>messages</code> property.
   * This is a special folder to conatin user defined FlexMessages.
   * A FlexMessage is a collection of FlexMessageBlock references and FlexMessageElements used to model a native device message.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#getMessages
   * @see com.tridium.flexSerial.BFlexSerialNetwork#setMessages
   */
  public static final Property messages = newProperty(0, new BFlexMessageFolder(),null);

  /**
   * Get the <code>messages</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#messages
   */
  public BFlexMessageFolder getMessages() { return (BFlexMessageFolder)get(messages); }

  /**
   * Set the <code>messages</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#messages
   */
  public void setMessages(BFlexMessageFolder v) { set(messages,v,null); }

////////////////////////////////////////////////////////////////
// Property "initMessage"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>initMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#getInitMessage
   * @see com.tridium.flexSerial.BFlexSerialNetwork#setInitMessage
   */
  public static final Property initMessage = newProperty(0, new BFlexRequestResponse(),null);

  /**
   * Get the <code>initMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#initMessage
   */
  public BFlexRequestResponse getInitMessage() { return (BFlexRequestResponse)get(initMessage); }

  /**
   * Set the <code>initMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#initMessage
   */
  public void setInitMessage(BFlexRequestResponse v) { set(initMessage,v,null); }

////////////////////////////////////////////////////////////////
// Topic "unsolicitedMessageReceived"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>unsolicitedMessageReceived</code> topic.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#fireUnsolicitedMessageReceived
   */
  public static final Topic unsolicitedMessageReceived = newTopic(0,null);

  /**
   * Fire an event for the <code>unsolicitedMessageReceived</code> topic.
   * @see com.tridium.flexSerial.BFlexSerialNetwork#unsolicitedMessageReceived
   */
  public void fireUnsolicitedMessageReceived(BValue event) { fire(unsolicitedMessageReceived, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexSerialNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Licensing
////////////////////////////////////////////////////////////////

  /**
   * If this driver is to be licensed using the standard licensing
   * mechanism then override this method to return the Feature or
   * return null for no license checks.  Convention is that the
   * vendor and feature name matches the declaring module.
   */
  public Feature getLicenseFeature()
  {
    return Sys.getLicenseManager().getFeature("tridium", "flexSerial");
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Returns the BModbusAsciiDevice type.
   */
  public Type getDeviceType()
  {
    return BFlexSerialDevice.TYPE;
  }

  /**
   * Returns folder type.
   */
  public Type getDeviceFolderType()
  {
    return BFlexSerialDeviceFolder.TYPE;
  }

  /**
   * Return a new instance of the custom ModbusAscii communication
   * handler
   */
  protected Comm makeComm()
  {
    return new FlexSerialComm(this);
  }

  public void started()
  throws Exception
  {
    super.started();
    FlexSerialComm comm = (FlexSerialComm)getComm();
    messageDefChanged();
    comm.setMaxReceiveSilentTime(getMaxReceiveSilentTime());

    getInitMessage().forceMessage();
    unsolicitedReceive = new FlexSerialUnsolicitedReceive(this);
    unsolicitedReceive.init();
    comm.registerListener(unsolicitedReceive);
    unsolicitedReceive.start();

  }

  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if(!isRunning()) return;

    //System.out.println(" serialNetworkChanged with: " + p);
    //if(p.equals(sendMessageSetup) || p.equals(receiveMessageSetup))
    //{
    //  messageDefChanged();
    //}
    //else if(p.equals(stripReceiveFraming))
    //{
    //  FlexSerialComm comm = (FlexSerialComm)getComm();
    //  comm.setStripReceiveFraming(getStripReceiveFraming());
    //}
    //else if(p.equals(maxReceiveSilentTime))
    if(p.equals(maxReceiveSilentTime))
    {
      ((FlexSerialComm)getComm()).setMaxReceiveSilentTime(getMaxReceiveSilentTime());
    }

  }

  public void messageDefChanged()
  {
    FlexSerialComm comm = (FlexSerialComm)getComm();
    //comm.setSendMessageSetup(getSendMessageSetup());
    //comm.setReceiveMessageSetup(getReceiveMessageSetup());
    comm.setReceiveMessageSetup(getMessageBlocks().getFrameStart().getByteArray(),
                                getMessageBlocks().getFrameEnd().getByteArray()    );
  }

  //public void doPing()
  //{
  //  pingFail("ping fail");
  //}


  /**
   * Filter out frozen slots which except for message folders.
   *
   */
  public BINavNode[] getNavChildren()
  {
    //BINavNode[] kids = super.getNavChildren();
    BINavNode[] kids = getNavChildren1();
    Array<BINavNode> acc = new Array<>(BINavNode.class);
    for(int i=0; i<kids.length; ++i)
    {
      BComponent kid = (BComponent)kids[i];
      //System.out.println("getNavChildren: " + kid.getName());
      if (kid.getPropertyInParent().isFrozen()      &&
          !(kid instanceof BFlexMessageBlockFolder) &&
          !(kid instanceof BFlexMessageFolder)              ) continue;
      acc.add(kid);
    }
    return acc.trim();
  }


  /**
   * Return all the non-hidden child components..
   */
  public BINavNode[] getNavChildren1()
  {
    loadSlots();
    BComponent[] temp = new BComponent[getSlotCount()];
    SlotCursor<Property> c = getProperties();
    int count = 0;
    while(c.nextComponent())
    {
      BComponent kid = (BComponent)c.get();
      //System.out.println("getNavChildrenxxx: " + kid.getName());
      if (Flags.isHidden(this, c.property())) continue;
      if (!kid.isNavChild()) continue;
      temp[count++] = kid;
    }

    BComponent[] result = new BComponent[count];
    System.arraycopy(temp, 0, result, 0, count);
    return result;
  }

  public static BFlexSerialNetwork getParentFlexNetwork(BComplex child)
  {
    BComplex parent = child.getParent();
    //System.out.println(" getParentFlexNetwork -- child = " + child);
    while (parent != null)
    {
      //stem.out.println(" getParentFlexNetwork -- parent = " + parent.getName());
      if(parent instanceof BFlexSerialNetwork)
        return (BFlexSerialNetwork)parent;
      parent = parent.getParent();
    }
    return null;
  }

////////////////////////////////////////////////////////////////
// attributes
////////////////////////////////////////////////////////////////

  FlexSerialUnsolicitedReceive unsolicitedReceive;
}
