/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial;

import javax.baja.driver.point.BReadWriteMode;
import javax.baja.sys.*;
import javax.baja.util.*;

import com.tridium.basicdriver.*;

import com.tridium.flexSerial.messages.*;
import com.tridium.flexSerial.point.*;

/**
 * BFlexSerialDevice represents a Modbus device
 * which supports Modbus Ascii communication.
 *
 * @author    Brian Frank       
 * @creation  21 Jan 02
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BFlexSerialDevice
  extends BBasicDevice
{ 
  /*-
  class BFlexSerialDevice
  {
    properties
    {
      address: String
        default {[ "" ]}
        
      initMessage: BFlexRequestResponse
        default {[ new BFlexRequestResponse() ]}

      pingMessage: BFlexRequestResponse
        default {[ new BFlexRequestResponse() ]}
        
      points: BFlexPointDeviceExt
        default {[ new BFlexPointDeviceExt() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.BFlexSerialDevice(61145015)1.0$ @*/
/* Generated Thu Sep 29 15:47:07 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "address"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#getAddress
   * @see com.tridium.flexSerial.BFlexSerialDevice#setAddress
   */
  public static final Property address = newProperty(0, "",null);
  
  /**
   * Get the <code>address</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#address
   */
  public String getAddress() { return getString(address); }
  
  /**
   * Set the <code>address</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#address
   */
  public void setAddress(String v) { setString(address,v,null); }

////////////////////////////////////////////////////////////////
// Property "initMessage"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>initMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#getInitMessage
   * @see com.tridium.flexSerial.BFlexSerialDevice#setInitMessage
   */
  public static final Property initMessage = newProperty(0, new BFlexRequestResponse(),null);
  
  /**
   * Get the <code>initMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#initMessage
   */
  public BFlexRequestResponse getInitMessage() { return (BFlexRequestResponse)get(initMessage); }
  
  /**
   * Set the <code>initMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#initMessage
   */
  public void setInitMessage(BFlexRequestResponse v) { set(initMessage,v,null); }

////////////////////////////////////////////////////////////////
// Property "pingMessage"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pingMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#getPingMessage
   * @see com.tridium.flexSerial.BFlexSerialDevice#setPingMessage
   */
  public static final Property pingMessage = newProperty(0, new BFlexRequestResponse(),null);
  
  /**
   * Get the <code>pingMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#pingMessage
   */
  public BFlexRequestResponse getPingMessage() { return (BFlexRequestResponse)get(pingMessage); }
  
  /**
   * Set the <code>pingMessage</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#pingMessage
   */
  public void setPingMessage(BFlexRequestResponse v) { set(pingMessage,v,null); }

////////////////////////////////////////////////////////////////
// Property "points"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>points</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#getPoints
   * @see com.tridium.flexSerial.BFlexSerialDevice#setPoints
   */
  public static final Property points = newProperty(0, new BFlexPointDeviceExt(),null);
  
  /**
   * Get the <code>points</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#points
   */
  public BFlexPointDeviceExt getPoints() { return (BFlexPointDeviceExt)get(points); }
  
  /**
   * Set the <code>points</code> property.
   * @see com.tridium.flexSerial.BFlexSerialDevice#points
   */
  public void setPoints(BFlexPointDeviceExt v) { set(points,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexSerialDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
  * Overrides isParentLegal method.  BModbusAsciiDevices
  * must reside under a BModbusAsciiNetwork.
  */
  public boolean isParentLegal(BComponent parent)
  {
    return (parent instanceof BFlexSerialNetwork  ||
            parent instanceof BFlexSerialDeviceFolder );
  }
  
  /**
   * Ping implementation.
   */
  public void doPing()
  {

    if(firstPing || isDown())
    {
      getInitMessage().sendMessage(BRelTime.makeSeconds(3));
      firstPing = false;
    }
    
    // if ping message not defined call pingOK()
    if( getPingMessage().isRequestDefined() )
    {  
      String results = getPingMessage().sendMessage(null);
      if(results.equals("OK"))
        pingOk();
      else
        pingFail(results);
    }
    else
      pingOk();
  }

  boolean firstPing = true;

}
