/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.video;

import javax.baja.file.BIFileStore;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BQuickTimeFile stores QuickTime videos.
 *
 * @author    Tom Duffy       
 * @creation  13 Jun 2013
 */
public class BQuickTimeFile
  extends BVideoFile
{
  ////////////////////////////////////////////////////////////////
  //Constructor
  ////////////////////////////////////////////////////////////////
  
  /**
  * Construct a file with the specified store.
  */
  public BQuickTimeFile(BIFileStore store)
  {
    super(store);
  }
  
  /**
   * Construct (must call setStore()).
   */
  public BQuickTimeFile()
  {  
  }
  
  ////////////////////////////////////////////////////////////////
  //Overrides
  ////////////////////////////////////////////////////////////////
  
  /**
  * Return {@code "video/quicktime"}.
  */
  @Override
  public String getMimeType()
  {
    return "video/quicktime";
  }

  ////////////////////////////////////////////////////////////////
  //Type
  ////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BQuickTimeFile.class);
}
