/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.text;

import javax.baja.file.BIFileStore;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BCssFile stores a CSS cascading style sheet.
 *
 * @author    Brian Frank       
 * @creation  10 Jun 04
 * @version   $Revision: 1$ $Date: 6/10/04 11:10:15 AM EDT$
 * @since     Baja 1.0
 */
public class BCssFile
  extends BTextFile
{ 

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Construct a file with the specified store.
   */
  public BCssFile(BIFileStore store)
  {
    super(store);
  }

  /**
   * Construct (must call setStore()).
   */
  public BCssFile()
  {  
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Return {@code "text/css"}.
   */
  @Override
  public String getMimeType()
  {
    return "text/css";
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCssFile.class);

}
