/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.image;

import javax.baja.file.BIFileStore;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIcoFile stores a GIF image
 *
 * @author    Andy Frank       
 * @creation  25 Oct 06
 * @version   $Revision: 1$ $Date: 10/25/06 3:14:53 PM EDT$
 * @since     Baja 1.0
 */
public class BIcoFile
  extends BImageFile
{ 

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Construct a file with the specified store.
   */
  public BIcoFile(BIFileStore store)
  {
    super(store);
  }

  /**
   * Construct (must call setStore()).
   */
  public BIcoFile()
  {  
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Return {@code "image/x-icon"}.
   */
  @Override
  public String getMimeType()
  {
    return "image/x-icon";
  }
      
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BIcoFile.class);


}
