/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.file.exporters;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/**
 * BITableToText.
 *
 * @author    Brian Frank       
 * @creation  20 Oct 04
 * @version   $Revision: 6$ $Date: 2/11/11 12:32:01 PM EST$
 * @since     Baja 1.0
 */
public class BITableToText
  extends BExporter
{             
  /*-
  
  class BITableToText
  {
    properties
    {
      columnSeparator: String
        default{[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.file.exporters.BITableToText(3310238535)1.0$ @*/
/* Generated Wed Oct 20 17:38:32 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "columnSeparator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code columnSeparator} property.
   * @see com.tridium.file.exporters.BITableToText#getColumnSeparator
   * @see com.tridium.file.exporters.BITableToText#setColumnSeparator
   */
  public static final Property columnSeparator = newProperty(0, "",null);
  
  /**
   * Get the {@code columnSeparator} property.
   * @see com.tridium.file.exporters.BITableToText#columnSeparator
   */
  public String getColumnSeparator() { return getString(columnSeparator); }
  
  /**
   * Set the {@code columnSeparator} property.
   * @see com.tridium.file.exporters.BITableToText#columnSeparator
   */
  public void setColumnSeparator(String v) { setString(columnSeparator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BITableToText.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/    

////////////////////////////////////////////////////////////////
// Exporter
////////////////////////////////////////////////////////////////

  @Override
  public TypeInfo getFileType()
  {
    return BTextFile.TYPE.getTypeInfo();
  }

  @Override
  public String getFileExtension()
  {
    return "txt";
  }

  @Override
  public void export(ExportOp op)
    throws Exception
  {            
    // target is ITable      
    export((BITable)op.get(), op);
  }
  
  public void export(BITable<?> table, ExportOp op)
    throws Exception
  {                   
    // build array of Rows
    //Array rows = new Array();
    //Replaced the above Array with ArrayList
    ArrayList<Row> rows = new ArrayList<>();

    // add column row
    Column[] cols   = table.getColumns().list();
    int colCount    = cols.length;
    int[] maxWidth  = new int[colCount];
    Row header = new Row(colCount);
    for(int i=0; i<colCount; ++i)
    {             
      //include unit information with column name
      BFacets colFacets = cols[i].getFacets();
      BUnit units = null;
      BObject sName = null;
      if( null != colFacets)
      {
        units = (BUnit)colFacets.get(BFacets.UNITS);
        sName = colFacets.get("SERIES_NAME");
      }
      String name = cols[i].getDisplayName(op);
      if( null != sName)
      {
        name = sName.toString(op); //": " + name;
      }
      if( null != units && units != BUnit.NULL)
      {
        name += " (" + units.toString(op) + ")";
      }
      
      Cell cell = new Cell(name);
      header.cells[i] = cell;
      maxWidth[i] = cell.width;
    }                                  
    rows.add(header);
    
    // column facets
    Context[] colCx = new Context[colCount];
    for (int i=0; i<colCx.length; i++)
    {
      colCx[i] = new BasicContext(op, cols[i].getFacets());
    }
        
    // add data rows  
    TableCursor<?> cursor = table.cursor();
    while (cursor.next())
    {              
      Row row = new Row(colCount);
      for(int i=0; i<colCount; ++i)
      {            
        BObject object = cursor.cell(cols[i]).as(BObject.class);
        String s = object.toString(colCx[i]); 
        Cell cell = new Cell(s);
        row.cells[i] = cell;
        maxWidth[i] = Math.max(maxWidth[i], cell.width);
      }        
      rows.add(row);
    }
    
    // now output                            
    PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), "UTF-8"));
    String spacer = " " + getColumnSeparator() + " ";
    for(int i=0; i<rows.size(); ++i)
    {                 
      Row row = rows.get(i);
      row.print(out, maxWidth, i == 0, spacer);
    }              
    out.flush();
  }   

  static String spaces(int n)
  {             
    return TextUtil.getSpaces(n);
  }

  static class Row
  {            
    Row(int colCount)
    {
      cells = new Cell[colCount];
    }      
    
    public void print(PrintWriter out, int[] maxWidth, boolean header, String spacer)
    {                
      int colCount = maxWidth.length;
      
      // first compute the number of lines of cells combined
      int lineCount = 0;
      for(int i=0; i<colCount; ++i)
      {
        lineCount = Math.max(cells[i].lines.length, lineCount);
      }
      
      // now output the lines
      for(int line=0; line<lineCount; ++line)
      {
        for(int i=0; i<colCount; ++i)
        {
          Cell cell = cells[i];
          if (line >= cell.lines.length) 
          {
            out.print(spaces(maxWidth[i]));
          }
          else
          {                    
            String s = cell.lines[line];
            out.print(s);
            out.print(spaces(maxWidth[i]-s.length()));
          }
          if (i < colCount-1)
          {
            out.print(spacer);
          }
        }
        out.println();
      }  
      
      // underline header
      if (header)
      {
        for(int i=0; i<colCount; ++i)
        {                            
          for(int x=0; x<maxWidth[i]; ++x)
          {
            out.print('-');
          }
          if (i < colCount-1)
          {
            out.print(spacer);
          }
        }
        out.println();
      } 
    }   
    
    Cell[] cells;
  }
  
  static class Cell
  {                
    Cell(String s)
    {                   
      lines = TextUtil.split(s, '\n');
      for(int i=0; i<lines.length; ++i)
      {
        width = Math.max(width, lines[i].length());
      }
    }
    
    String[] lines;
    int width;
  }               
  
  static final int pad = 2;
    
}
