/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.driver.ui.history;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrModel;

/**
 * BHistoryImportManager is the base class plugin for managing the transfer
 * of histories from a remote device into the local station.
 *
 * @author    John Sublett
 * @creation  05 Jan 2004
 * @version   $Revision: 4$ $Date: 5/26/04 7:19:40 AM EDT$
 * @since     Baja 1.0
 */
public class BHistoryImportManager
  extends BArchiveManager
{
  public static final Type TYPE = Sys.loadType(BHistoryImportManager.class);
  public Type getType() { return TYPE; }

  public BHistoryImportManager()
  {
  }
 
  /**
   * Create the model for this manager.  This method calls makeImportModel().
   */
  protected final MgrModel makeModel()
  {
    return makeImportModel();
  }

  /**
   * Create the import model for this manager.
   */
  protected ImportModel makeImportModel()
  {
    return new ImportModel(this);
  }
}