/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.util;

import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BAbstractPollService is the base class for services that poll
 * points, objects, or devices in a device network.
 *
 * @author    Craig Gemmill
 * @creation  31 Oct 2003
 * @version   $Revision: 3$ $Date: 6/22/10 1:28:16 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BAbstractPollService
  extends BComponent
{
  /*-
  class BAbstractPollService
  {
    properties
    {
      pollEnabled: boolean
        -- Enable the poll engine.
        default {[ true ]}
    }

    actions
    {
      enable()
        -- Enable polling.
      disable()
        -- Disable polling.
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.util.BAbstractPollService(2578206984)1.0$ @*/
/* Generated Tue Jun 22 13:23:24 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "pollEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollEnabled</code> property.
   * Enable the poll engine.
   * @see javax.baja.driver.util.BAbstractPollService#getPollEnabled
   * @see javax.baja.driver.util.BAbstractPollService#setPollEnabled
   */
  public static final Property pollEnabled = newProperty(0, true,null);
  
  /**
   * Get the <code>pollEnabled</code> property.
   * @see javax.baja.driver.util.BAbstractPollService#pollEnabled
   */
  public boolean getPollEnabled() { return getBoolean(pollEnabled); }
  
  /**
   * Set the <code>pollEnabled</code> property.
   * @see javax.baja.driver.util.BAbstractPollService#pollEnabled
   */
  public void setPollEnabled(boolean v) { setBoolean(pollEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Action "enable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enable</code> action.
   * Enable polling.
   * @see javax.baja.driver.util.BAbstractPollService#enable()
   */
  public static final Action enable = newAction(0,null);
  
  /**
   * Invoke the <code>enable</code> action.
   * @see javax.baja.driver.util.BAbstractPollService#enable
   */
  public void enable() { invoke(enable,null,null); }

////////////////////////////////////////////////////////////////
// Action "disable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>disable</code> action.
   * Disable polling.
   * @see javax.baja.driver.util.BAbstractPollService#disable()
   */
  public static final Action disable = newAction(0,null);
  
  /**
   * Invoke the <code>disable</code> action.
   * @see javax.baja.driver.util.BAbstractPollService#disable
   */
  public void disable() { invoke(disable,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAbstractPollService.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  /** Enable polling */
  public void doEnable() { setPollEnabled(true); }

  /** Disable polling */
  public void doDisable() { setPollEnabled(false); }


////////////////////////////////////////////////////////////////
// Subscriptions
////////////////////////////////////////////////////////////////

  /**
   * Subscribe the pollable and start polling it
   * until it is unsubscrbed.
   */
  abstract public void subscribe(BIPollable p);

  /**
   * Unsubscribe the pollable and stop polling it.
   * @returns true if the pollable point was subscribed,
   *          false if the point was not in any buckets.
   */
  abstract public boolean unsubscribe(BIPollable p);


////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("pollService.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

}
