/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.point;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BReadWriteMode indicates readonly, read-write, or writeonly capability.
 *
 * @author    Brian Frank       
 * @creation  22 Jun 04
 * @version   $Revision: 1$ $Date: 6/24/04 2:24:45 PM EDT$
 * @since     Baja 1.0
 */
public final class BReadWriteMode
  extends BFrozenEnum
{ 

  /*-
  
  enum BReadWriteMode
  {  
    range 
    {                   
      readonly,
      readWrite,
      writeonly
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.point.BReadWriteMode(677396054)1.0$ @*/
/* Generated Thu Feb 02 16:36:02 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for readonly. */
  public static final int READONLY = 0;
  /** Ordinal value for readWrite. */
  public static final int READ_WRITE = 1;
  /** Ordinal value for writeonly. */
  public static final int WRITEONLY = 2;
  
  /** BReadWriteMode constant for readonly. */
  public static final BReadWriteMode readonly = new BReadWriteMode(READONLY);
  /** BReadWriteMode constant for readWrite. */
  public static final BReadWriteMode readWrite = new BReadWriteMode(READ_WRITE);
  /** BReadWriteMode constant for writeonly. */
  public static final BReadWriteMode writeonly = new BReadWriteMode(WRITEONLY);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BReadWriteMode.class);
  
  /** Factory method with ordinal. */
  public static BReadWriteMode make(int ordinal)
  {
    return (BReadWriteMode)readonly.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BReadWriteMode make(String tag)
  {
    return (BReadWriteMode)readonly.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BReadWriteMode(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BReadWriteMode DEFAULT = BReadWriteMode.readonly;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Return if readonly.
   */
  public boolean isReadonly()
  {
    return this == readonly;
  }
  
  /**
   * Return if readonly or readWrite.
   */
  public boolean isRead()
  {
    return this == readonly || this == readWrite;
  }

  /**
   * Return if readWrite or writeonly.
   */
  public boolean isWrite()
  {
    return this == readWrite || this == writeonly;
  }

  /**
   * Return if writeonly.
   */
  public boolean isWriteonly()
  {
    return this == writeonly;
  }

  public String getDisplayTag(Context cx)
  {           
    switch(getOrdinal())
    {
      case READONLY:   return "RO";
      case READ_WRITE: return "RW";
      case WRITEONLY:  return "WO";
    }                              
    throw new IllegalStateException();
  }

}
