/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.point;

import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIPointFolder is the common interface for 
 * BPointDeviceExt and BPointFolder.
 *
 * @author    Brian Frank       
 * @creation  29 Jun 04
 * @version   $Revision: 1$ $Date: 6/29/04 4:30:53 PM EDT$
 * @since     Baja 1.0
 */
public interface BIPointFolder
  extends BInterface
{                       

  /**
   * Get the parent network.
   */
  public BDeviceNetwork getNetwork();

  /**
   * Get the parent device.
   */
  public BDevice getDevice();

  /**
   * Get the parent point device extension.
   */
  public BPointDeviceExt getDeviceExt();
  
  /**
   * Get the type of ProxyExt for this driver.
   */
  public Type getProxyExtType();

  /**
   * Get the type of PointFolder for this driver.
   */
  public Type getPointFolderType();
    
  
  public static final Type TYPE = Sys.loadType(BIPointFolder.class);

}
