/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.ping;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStruct;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BPingHealth manages the ping status of a BIPingable.  It should
 * be a child property of BIPingable.
 *
 * @author    Brian Frank
 * @creation  6 May 02
 * @version   $Revision: 9$ $Date: 1/11/11 5:06:12 PM EST$
 * @since     Baja 1.0
 */
public class BPingHealth
  extends BStruct
{

  /*-
  
  class BPingHealth
  {
    properties
    {               
      down: boolean
        -- Indicates the state of the communication health.
        -- If the last result was ok then the pingable is
        -- up, otherwise it is down.
        flags { readonly }
        default {[ false ]}
        
      alarm: boolean
        -- Indicates the alarm state of the communication health.
        -- If alarming is enabled and the last result was fail then the pingable
        -- is in alarm.
        flags { readonly }
        default {[ false ]}
        
      lastOkTime: BAbsTime
        -- Last time the device was successfully pinged
        -- and we knew it was up and communicating.
        flags { readonly,non_critical }
        default {[ BAbsTime.DEFAULT ]}

      lastFailTime: BAbsTime
        -- Last time we attempted communication with the
        -- device and failed.
        flags { readonly }
        default {[ BAbsTime.DEFAULT ]}      

      lastFailCause: String
        flags { readonly }
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.ping.BPingHealth(1490252533)1.0$ @*/
/* Generated Tue Mar 11 12:14:27 EDT 2014 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "down"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>down</code> property.
   * Indicates the state of the communication health. If
   * the last result was ok then the pingable is up, otherwise
   * it is down.
   * @see javax.baja.driver.ping.BPingHealth#getDown
   * @see javax.baja.driver.ping.BPingHealth#setDown
   */
  public static final Property down = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>down</code> property.
   * Indicates the state of the communication health. If
   * the last result was ok then the pingable is up, otherwise
   * it is down.
   * @see javax.baja.driver.ping.BPingHealth#down
   */
  public boolean getDown() { return getBoolean(down); }
  
  /**
   * Set the <code>down</code> property.
   * Indicates the state of the communication health. If
   * the last result was ok then the pingable is up, otherwise
   * it is down.
   * @see javax.baja.driver.ping.BPingHealth#down
   */
  public void setDown(boolean v) { setBoolean(down,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarm</code> property.
   * Indicates the alarm state of the communication health.
   * If alarming is enabled and the last result was fail
   * then the pingable is in alarm.
   * @see javax.baja.driver.ping.BPingHealth#getAlarm
   * @see javax.baja.driver.ping.BPingHealth#setAlarm
   */
  public static final Property alarm = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>alarm</code> property.
   * Indicates the alarm state of the communication health.
   * If alarming is enabled and the last result was fail
   * then the pingable is in alarm.
   * @see javax.baja.driver.ping.BPingHealth#alarm
   */
  public boolean getAlarm() { return getBoolean(alarm); }
  
  /**
   * Set the <code>alarm</code> property.
   * Indicates the alarm state of the communication health.
   * If alarming is enabled and the last result was fail
   * then the pingable is in alarm.
   * @see javax.baja.driver.ping.BPingHealth#alarm
   */
  public void setAlarm(boolean v) { setBoolean(alarm,v,null); }

////////////////////////////////////////////////////////////////
// Property "lastOkTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lastOkTime</code> property.
   * Last time the device was successfully pinged and we
   * knew it was up and communicating.
   * @see javax.baja.driver.ping.BPingHealth#getLastOkTime
   * @see javax.baja.driver.ping.BPingHealth#setLastOkTime
   */
  public static final Property lastOkTime = newProperty(Flags.READONLY|Flags.NON_CRITICAL, BAbsTime.DEFAULT,null);
  
  /**
   * Get the <code>lastOkTime</code> property.
   * Last time the device was successfully pinged and we
   * knew it was up and communicating.
   * @see javax.baja.driver.ping.BPingHealth#lastOkTime
   */
  public BAbsTime getLastOkTime() { return (BAbsTime)get(lastOkTime); }
  
  /**
   * Set the <code>lastOkTime</code> property.
   * Last time the device was successfully pinged and we
   * knew it was up and communicating.
   * @see javax.baja.driver.ping.BPingHealth#lastOkTime
   */
  public void setLastOkTime(BAbsTime v) { set(lastOkTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "lastFailTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lastFailTime</code> property.
   * Last time we attempted communication with the device
   * and failed.
   * @see javax.baja.driver.ping.BPingHealth#getLastFailTime
   * @see javax.baja.driver.ping.BPingHealth#setLastFailTime
   */
  public static final Property lastFailTime = newProperty(Flags.READONLY, BAbsTime.DEFAULT,null);
  
  /**
   * Get the <code>lastFailTime</code> property.
   * Last time we attempted communication with the device
   * and failed.
   * @see javax.baja.driver.ping.BPingHealth#lastFailTime
   */
  public BAbsTime getLastFailTime() { return (BAbsTime)get(lastFailTime); }
  
  /**
   * Set the <code>lastFailTime</code> property.
   * Last time we attempted communication with the device
   * and failed.
   * @see javax.baja.driver.ping.BPingHealth#lastFailTime
   */
  public void setLastFailTime(BAbsTime v) { set(lastFailTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "lastFailCause"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lastFailCause</code> property.
   * @see javax.baja.driver.ping.BPingHealth#getLastFailCause
   * @see javax.baja.driver.ping.BPingHealth#setLastFailCause
   */
  public static final Property lastFailCause = newProperty(Flags.READONLY, "",null);
  
  /**
   * Get the <code>lastFailCause</code> property.
   * @see javax.baja.driver.ping.BPingHealth#lastFailCause
   */
  public String getLastFailCause() { return getString(lastFailCause); }
  
  /**
   * Set the <code>lastFailCause</code> property.
   * @see javax.baja.driver.ping.BPingHealth#lastFailCause
   */
  public void setLastFailCause(String v) { setString(lastFailCause,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPingHealth.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get the parent as a <code>BIPingable</code>.
   */
  public final BIPingable getParentPingable()
  {
    return (BIPingable)getParent();
  }

////////////////////////////////////////////////////////////////
// Callbacks
////////////////////////////////////////////////////////////////  

  /**
   * Return if the last failure time was more recent 
   * than then the last success time.
   */
  public boolean inFailure()
  {
    return getLastFailTime().getMillis() >= 
           getLastOkTime().getMillis();
  }

  /**
   * Called when successful communication is made.  This method
   * updates the lastOkTime and clears the down flag.
   */
  public void pingOk()
  {                         
    lastAttemptTicks = Clock.ticks();
    
    long now = System.currentTimeMillis();
    long truncated = now - (now % 60000L);
    BAbsTime t = (truncated <= (getLastFailTime().getMillis()))?BAbsTime.make(now):BAbsTime.make(truncated);
    setLastOkTime(t);
    BIPingable parent = getParentPingable();
    if (getDown())
    { 
      setDown(false); 
      parent.updateStatus();
    }
    parent.getMonitor().pingOk(parent);
  }

  /**
   * Called when communication with the pingable fails.  This method 
   * updates the lastFail properties and sets the down flag.
   */
  public void pingFail(String cause)
  {
    lastAttemptTicks = Clock.ticks();
    
    long now = System.currentTimeMillis();
    long truncated = now - (now % 60000L);
    BAbsTime t = (truncated <= (getLastOkTime().getMillis()))?BAbsTime.make(now):BAbsTime.make(truncated);
    setLastFailTime(t);
    setLastFailCause(cause == null ? "" : cause);
    BIPingable parent = getParentPingable();
    if (!getDown())
    { 
      setDown(true);
      parent.updateStatus();
    }
    
    try
    {
      parent.getMonitor().pingFail(parent);
    }
    catch(Exception e)
    { 
      // don't propagate exception if we can't access network
      // such as in a fatal fault condition
    }
  }
  
  /**
   * Called on alarm acknowledge.  Clears the unack alarm bit.
   */
  public BBoolean doAckAlarm(BAlarmRecord ackRequest)
  {                     
    BIPingable parent = getParentPingable();
    return parent.getMonitor().alarmAck(parent, ackRequest);
  }

////////////////////////////////////////////////////////////////
// Utils
////////////////////////////////////////////////////////////////  
  
  /**
   * To string.
   */
  public String toString(Context cx)
  {
    if (inFailure())
      return "Fail [" + getLastFailTime().toString(cx) + "] " + getLastFailCause();
    else
      return "Ok [" + getLastOkTime().toString(cx) + "]";
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("monitor.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  
  
  long lastAttemptTicks = 0;
}

