/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.loadable;

import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The ILoadable interface is implemented by BComponents 
 * which support async upload and download actions.
 *
 * @author    Robert Adams
 * @creation  4 Feb 02
 * @version   $Revision: 2$ $Date: 2/11/04 4:14:14 PM EST$
 * @since     Baja 1.0
 */
public interface BILoadable
  extends BInterface
{
  
  /**
   * Invocation for async upload action.
   */                                   
  public void upload(BUploadParameters params);

  /**
   * Implementation for async upload action.
   */                                   
  public void doUpload(BUploadParameters params, Context cx)
    throws Exception;

  /**
   * Invocation for async download action.
   */                                   
  public void download(BDownloadParameters params);
  
  /**
   * Implementation for async download action.
   */                                   
  public void doDownload(BDownloadParameters params, Context cx)
    throws Exception;       
    

  public static final Type TYPE = Sys.loadType(BILoadable.class);

}
