/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.history;

import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BHistoryPollScheduler
 *
 * @author    Scott Hoye
 * @creation  03 Apr 08
 * @version   $Revision: 3$ $Date: 7/28/09 12:27:41 PM EDT$  
 * @since     Niagara 3.4  
 */
public class BHistoryPollScheduler
  extends BPollScheduler
{
  /*-

  class BHistoryPollScheduler
  {
    properties
    {
      fastRate: BRelTime
        -- The frequency used to poll history import descriptors set to fast.
        default {[ BRelTime.make(10000) ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BRelTime.make(1))]}
      normalRate: BRelTime
        -- The frequency used to poll history import descriptors set to normal.
        default {[ BRelTime.make(45000) ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BRelTime.make(1))]}
      slowRate: BRelTime
        -- The frequency used to poll history import descriptors set to slow.
        default {[ BRelTime.make(120000) ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BRelTime.make(1))]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.history.BHistoryPollScheduler(1608018680)1.0$ @*/
/* Generated Tue Jul 28 12:26:27 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "fastRate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fastRate</code> property.
   * The frequency used to poll history import descriptors
   * set to fast.
   * @see javax.baja.driver.history.BHistoryPollScheduler#getFastRate
   * @see javax.baja.driver.history.BHistoryPollScheduler#setFastRate
   */
  public static final Property fastRate = newProperty(0, BRelTime.make(10000),BFacets.make(BFacets.MIN, BRelTime.make(1)));
  
  /**
   * Get the <code>fastRate</code> property.
   * @see javax.baja.driver.history.BHistoryPollScheduler#fastRate
   */
  public BRelTime getFastRate() { return (BRelTime)get(fastRate); }
  
  /**
   * Set the <code>fastRate</code> property.
   * @see javax.baja.driver.history.BHistoryPollScheduler#fastRate
   */
  public void setFastRate(BRelTime v) { set(fastRate,v,null); }

////////////////////////////////////////////////////////////////
// Property "normalRate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>normalRate</code> property.
   * The frequency used to poll history import descriptors
   * set to normal.
   * @see javax.baja.driver.history.BHistoryPollScheduler#getNormalRate
   * @see javax.baja.driver.history.BHistoryPollScheduler#setNormalRate
   */
  public static final Property normalRate = newProperty(0, BRelTime.make(45000),BFacets.make(BFacets.MIN, BRelTime.make(1)));
  
  /**
   * Get the <code>normalRate</code> property.
   * @see javax.baja.driver.history.BHistoryPollScheduler#normalRate
   */
  public BRelTime getNormalRate() { return (BRelTime)get(normalRate); }
  
  /**
   * Set the <code>normalRate</code> property.
   * @see javax.baja.driver.history.BHistoryPollScheduler#normalRate
   */
  public void setNormalRate(BRelTime v) { set(normalRate,v,null); }

////////////////////////////////////////////////////////////////
// Property "slowRate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>slowRate</code> property.
   * The frequency used to poll history import descriptors
   * set to slow.
   * @see javax.baja.driver.history.BHistoryPollScheduler#getSlowRate
   * @see javax.baja.driver.history.BHistoryPollScheduler#setSlowRate
   */
  public static final Property slowRate = newProperty(0, BRelTime.make(120000),BFacets.make(BFacets.MIN, BRelTime.make(1)));
  
  /**
   * Get the <code>slowRate</code> property.
   * @see javax.baja.driver.history.BHistoryPollScheduler#slowRate
   */
  public BRelTime getSlowRate() { return (BRelTime)get(slowRate); }
  
  /**
   * Set the <code>slowRate</code> property.
   * @see javax.baja.driver.history.BHistoryPollScheduler#slowRate
   */
  public void setSlowRate(BRelTime v) { set(slowRate,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryPollScheduler.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Poll the specified BIHistoryPollable.
   */
  public void doPoll(BIPollable p)
    throws Exception
  {
    if(p instanceof BIHistoryPollable)
      ((BIHistoryPollable)p).poll();
  }

}
