/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.driver.history;

import javax.baja.driver.util.BPollScheduler;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BHistoryNetworkExt manages network level functions for the
 * history transfers.  Its primary purpose is to be the container
 * of the rules that specify how the configuration of a history
 * should be changed when the history is pushed into a station.
 * <p>
 * Configuration rules are applied when a history is created.
 * Changing a rule has no effect on existing histories.
 *
 * @author    John Sublett
 * @creation  17 Apr 2003
 * @version   $Revision: 2$ $Date: 5/15/08 4:15:19 PM EDT$
 * @since     Baja 1.0
 */
public class BHistoryNetworkExt
  extends BComponent
{
  /*-
  
  class BHistoryNetworkExt
  {
    properties
    {
      onDemandPollScheduler: BPollScheduler
        -- Manages polling for subscribed history descriptors.
        -- @since Niagara 3.4
        default {[ new BHistoryPollScheduler() ]}
      defaultRule: BConfigRule
        -- The default rule for configuration of histories
        -- pushed to the local device.  This rule is applied
        -- when no other config rules are applicable.
        default {[ BConfigRule.makeDefault() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.history.BHistoryNetworkExt(787482437)1.0$ @*/
/* Generated Thu May 15 12:32:38 EDT 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "onDemandPollScheduler"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDemandPollScheduler</code> property.
   * Manages polling for subscribed history descriptors.
   * @since Niagara 3.4
   * @see javax.baja.driver.history.BHistoryNetworkExt#getOnDemandPollScheduler
   * @see javax.baja.driver.history.BHistoryNetworkExt#setOnDemandPollScheduler
   */
  public static final Property onDemandPollScheduler = newProperty(0, new BHistoryPollScheduler(),null);
  
  /**
   * Get the <code>onDemandPollScheduler</code> property.
   * @see javax.baja.driver.history.BHistoryNetworkExt#onDemandPollScheduler
   */
  public BPollScheduler getOnDemandPollScheduler() { return (BPollScheduler)get(onDemandPollScheduler); }
  
  /**
   * Set the <code>onDemandPollScheduler</code> property.
   * @see javax.baja.driver.history.BHistoryNetworkExt#onDemandPollScheduler
   */
  public void setOnDemandPollScheduler(BPollScheduler v) { set(onDemandPollScheduler,v,null); }

////////////////////////////////////////////////////////////////
// Property "defaultRule"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>defaultRule</code> property.
   * The default rule for configuration of histories pushed
   * to the local device.  This rule is applied when no
   * other config rules are applicable.
   * @see javax.baja.driver.history.BHistoryNetworkExt#getDefaultRule
   * @see javax.baja.driver.history.BHistoryNetworkExt#setDefaultRule
   */
  public static final Property defaultRule = newProperty(0, BConfigRule.makeDefault(),null);
  
  /**
   * Get the <code>defaultRule</code> property.
   * @see javax.baja.driver.history.BHistoryNetworkExt#defaultRule
   */
  public BConfigRule getDefaultRule() { return (BConfigRule)get(defaultRule); }
  
  /**
   * Set the <code>defaultRule</code> property.
   * @see javax.baja.driver.history.BHistoryNetworkExt#defaultRule
   */
  public void setDefaultRule(BConfigRule v) { set(defaultRule,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryNetworkExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Create a local configuration based on the specified
   * history config instance.
   */
  public BHistoryConfig makeConfig(BHistoryConfig original)
  {
    BHistoryId id = original.getId();
    BConfigRule rule = null;
    BConfigRule defaultRule = getDefaultRule();
    SlotCursor<Property> rules = loadSlots().getProperties();
    while (rules.next(BConfigRule.class))
    {
      BConfigRule test = (BConfigRule)rules.get();
      if (test == defaultRule) continue;
      if (test.isMatch(id))
        return test.makeConfig(original);
    }
    
    return defaultRule.makeConfig(original);
  }
}
