/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.driver.history;

import javax.baja.driver.util.BPollFrequency;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BHistoryImport defines an archive action for transferring
 * one or more histories from a remote source to the local
 * destination.
 *
 * @author    John Sublett
 * @creation  31 Mar 2003
 * @version   $Revision: 14$ $Date: 11/3/09 4:41:52 PM EST$
 * @since     Baja 1.0
 */
public abstract class BHistoryImport
  extends BArchiveDescriptor
  implements BIHistoryPollable, BIPollableHistorySource
{
  /*-
  
  class BHistoryImport
  {
    properties
    {
      onDemandPollEnabled: boolean
        -- Enables on demand polling for this history import.
        -- @since Niagara 3.4
        default {[ true ]}
      
      onDemandPollFrequency: BPollFrequency
        -- Poll frequency bucket, determines the polling rate.
        -- @since Niagara 3.4
        default {[ BPollFrequency.normal ]}
      
      configOverrides: BComponent
        -- Defines the configuration of the history that
        -- is created at the destination as a set of
        -- overrides from the default.
        default {[ new BComponent() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.history.BHistoryImport(1141721385)1.0$ @*/
/* Generated Fri Aug 29 16:05:06 EDT 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "onDemandPollEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDemandPollEnabled</code> property.
   * Enables on demand polling for this history import.
   * @since Niagara 3.4
   * @see javax.baja.driver.history.BHistoryImport#getOnDemandPollEnabled
   * @see javax.baja.driver.history.BHistoryImport#setOnDemandPollEnabled
   */
  public static final Property onDemandPollEnabled = newProperty(0, true,null);
  
  /**
   * Get the <code>onDemandPollEnabled</code> property.
   * @see javax.baja.driver.history.BHistoryImport#onDemandPollEnabled
   */
  public boolean getOnDemandPollEnabled() { return getBoolean(onDemandPollEnabled); }
  
  /**
   * Set the <code>onDemandPollEnabled</code> property.
   * @see javax.baja.driver.history.BHistoryImport#onDemandPollEnabled
   */
  public void setOnDemandPollEnabled(boolean v) { setBoolean(onDemandPollEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "onDemandPollFrequency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDemandPollFrequency</code> property.
   * Poll frequency bucket, determines the polling rate.
   * @since Niagara 3.4
   * @see javax.baja.driver.history.BHistoryImport#getOnDemandPollFrequency
   * @see javax.baja.driver.history.BHistoryImport#setOnDemandPollFrequency
   */
  public static final Property onDemandPollFrequency = newProperty(0, BPollFrequency.normal,null);
  
  /**
   * Get the <code>onDemandPollFrequency</code> property.
   * @see javax.baja.driver.history.BHistoryImport#onDemandPollFrequency
   */
  public BPollFrequency getOnDemandPollFrequency() { return (BPollFrequency)get(onDemandPollFrequency); }
  
  /**
   * Set the <code>onDemandPollFrequency</code> property.
   * @see javax.baja.driver.history.BHistoryImport#onDemandPollFrequency
   */
  public void setOnDemandPollFrequency(BPollFrequency v) { set(onDemandPollFrequency,v,null); }

////////////////////////////////////////////////////////////////
// Property "configOverrides"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>configOverrides</code> property.
   * Defines the configuration of the history that is created
   * at the destination as a set of overrides from the default.
   * @see javax.baja.driver.history.BHistoryImport#getConfigOverrides
   * @see javax.baja.driver.history.BHistoryImport#setConfigOverrides
   */
  public static final Property configOverrides = newProperty(0, new BComponent(),null);
  
  /**
   * Get the <code>configOverrides</code> property.
   * @see javax.baja.driver.history.BHistoryImport#configOverrides
   */
  public BComponent getConfigOverrides() { return (BComponent)get(configOverrides); }
  
  /**
   * Set the <code>configOverrides</code> property.
   * @see javax.baja.driver.history.BHistoryImport#configOverrides
   */
  public void setConfigOverrides(BComponent v) { set(configOverrides,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryImport.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BHistoryImport()
  {
  }

  /**
   * The specified parent is only legal if it or one
   * of its ancestors is a IArchiveFolder that
   * supports import.
   */
  public boolean isParentLegal(BComponent parent)
  {
    while ((parent != null) && !(parent instanceof BIArchiveFolder))
      parent = (BComponent)parent.getParent();
    
    if (parent == null) return false;
    
    try
    {
      return ((BIArchiveFolder)parent).getImportDescriptorType() != null;
    }
    catch(IllegalStateException e) { return true; }
  }

  /**
   * Create a local history configuration based on the specified
   * remote configuration.
   */
  public BHistoryConfig makeLocalConfig(BHistoryConfig remoteConfig)
  {
    BHistoryConfig newConfig = (BHistoryConfig)remoteConfig.newCopy(true);
    BComponent configChanges = getConfigOverrides();
    Property[] props = configChanges.getPropertiesArray();
    for (int i = 0; i < props.length; i++)
    {
      Property changeProp = props[i];
      BValue changeValue = configChanges.get(changeProp).newCopy(true);
      Property configProp = newConfig.getProperty(changeProp.getName());
      if (configProp == null)
        newConfig.add(changeProp.getName(), changeValue, configChanges.getFlags(changeProp), configChanges.getSlotFacets(changeProp), null);
      else
        newConfig.set(configProp, changeValue);
    }
    
    try
    {
      BOrd ord = getSourceOrd();
      BOrdList src = newConfig.getSource();
      if (src.size() < 1)
        newConfig.setSource(BOrdList.make(ord));
      else if (!src.get(src.size()-1).equals(ord))
      {
        BOrdList newSrc = BOrdList.add(src, ord);
        newConfig.setSource(newSrc);
      }
    }
    catch (Exception e) { e.printStackTrace(); }
    
    return newConfig;
  }
  
  /**
   * Get the ord to use as the source for the history.
   */
  private BOrd getSourceOrd()
  {
    BComponentSpace cs = getComponentSpace();
    if (cs == null) return getSlotPathOrd();
    BOrd base = cs.getOrdInSession();
    if (base == null) return getSlotPathOrd();
    return BOrd.make(base, getSlotPathOrd());
  }
  
  /**
   * Unsubscribed causes unregistration from the history poll scheduler
   * 
   * @since Niagara 3.4
   */
  public void unsubscribed()
  {
    synchronized(syncObj)
    {
      historySubscribeCounter = 0;
      if (ext != null)
        ext.getOnDemandPollScheduler().unsubscribe(this);
    }    
  }

////////////////////////////////////////////////////////////////
// BIHistoryPollable
////////////////////////////////////////////////////////////////

  /**
   * Callback when the history poll scheduler says its time to
   * poll the history.
   * 
   * @since Niagara 3.4
   */
  public void poll()
  {
    if (getOnDemandPollEnabled() && (!isUnoperational()) && (historySubscribeCounter > 0))
    {
      // invoke with a context to indicate a poll request
      invoke(execute,null,asyncHistoryPoll);
    }
  }

////////////////////////////////////////////////////////////////
// BIPollableHistorySource
////////////////////////////////////////////////////////////////  
  
  /**
   * Returns true if this object supports history polling (subscription), 
   * or false if it does not (does not support subscription).
   *
   * @since Niagara 3.4
   */
  public boolean historyPollingEnabled()
  {
    if (!getOnDemandPollEnabled()) return false;
    BHistoryNetworkExt historyExt = getHistoryNetworkExt();
    if (historyExt == null) return false;
    BPollScheduler scheduler = historyExt.getOnDemandPollScheduler();
    if (!isRunning()) scheduler.lease();
    return scheduler.getPollEnabled();
  }
    
  /**
   * This callback is made to cause the history subscription counter for this
   * history import to be incremented (positive change value) or decremented 
   * (negative change value).  The returning value is the current history 
   * subscription counter value after the increment/decrement 
   * has been processed.
   *
   * @since Niagara 3.4
   */
  public int updateHistorySubscriptionCount(int change)
  {
    int result = 0;
    boolean syncExecute = false;
    synchronized(syncObj)
    {
      int oldCount = historySubscribeCounter;
      historySubscribeCounter += change;
      if (historySubscribeCounter < 0) // paranoia
        historySubscribeCounter = 0;
      else if ((oldCount == 0) && (historySubscribeCounter > 0) && isRunning())
      {  
        ext = getHistoryNetworkExt();
        if (ext != null)
        {
          BPollScheduler scheduler = ext.getOnDemandPollScheduler();
          if (getOnDemandPollEnabled() &&
              (!isUnoperational()) && 
              scheduler.getPollEnabled() && 
              (historySubscribeCounter > 0))
          {
            syncExecute = true;
          }
          scheduler.subscribe(this);
        }
      }
      
      if ((historySubscribeCounter == 0) && (ext != null))
        ext.getOnDemandPollScheduler().unsubscribe(this);
      
      result = historySubscribeCounter;
    }
    
    if (syncExecute) // invoke with a context to indicate a poll request
      invoke(execute,null,syncHistoryPoll);
    
    return result;
  }
  
////////////////////////////////////////////////////////////////
// BIPollable
////////////////////////////////////////////////////////////////

  /**
   * Get the configured poll frequency.
   *
   * @since Niagara 3.4
   */
  public BPollFrequency getPollFrequency()
  {
    return getOnDemandPollFrequency();
  }

////////////////////////////////////////////////////////////////
//Spy
////////////////////////////////////////////////////////////////

  /**
   * Overridden to be sure to include spy info about the 
   * history subscription status.
   * 
   * @since Niagara 3.4
   */
  public void spy(SpyWriter out)
  throws Exception
  {
    // First append virtual space info
    out.startProps();
    out.trTitle("HistoryImport", 2);
    out.prop("historySubscriptionCount", ""+historySubscribeCounter);
    out.endProps();
    super.spy(out);
  }  
  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.make
    ("module://driver/com/tridium/driver/ui/history/importHistory.png");
  
  /**
   * This instance of context is passed when the execute
   * action is invoked due to an on-demand poll, and it should be
   * handled asynchronously.  In some special cases,
   * subclasses may want to handle the postExecute() differently
   * based on whether the execute() was called due to a normal archive,
   * or due to an on-demand poll.
   * 
   * @since Niagara 3.4
   */
  public static final Context asyncHistoryPoll = new BasicContext()
  {
    public boolean equals(Object obj) { return this == obj; }
    public int hashCode() { return System.identityHashCode(this); }
    public String toString() { return "Context.asyncHistoryPoll"; }
  };
  
  /**
   * This instance of context is passed when the execute
   * action is invoked due to a history subscribe, and it should be
   * handled synchronously.  In some special cases,
   * subclasses may want to handle the postExecute() differently
   * based on whether the execute() was called due to a normal archive,
   * or due to a history subscribe.
   * 
   * @since Niagara 3.4
   */
  public static final Context syncHistoryPoll = new BasicContext()
  {
    public boolean equals(Object obj) { return this == obj; }
    public int hashCode() { return System.identityHashCode(this); }
    public String toString() { return "Context.syncHistoryPoll"; }
  };
  
  BHistoryNetworkExt ext = null;
  int historySubscribeCounter = 0;
  Object syncObj = new Object();
}