/*
 * Copyright 2006, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.file.history;

import javax.baja.driver.file.BIFileDevice;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BFileHistoryImport defines an archive action for transferring
 * a history from a file to this station.  It will use the parent
 * BIFileDevice to resolve the file it needs to import.
 *
 * @author    Scott Hoye
 * @creation  06 Apr 06
 * @version   $Revision: 1$ $Date: 5/16/06 12:40:34 PM EDT$
 * @since     Baja 3.1
 */
public abstract class BFileHistoryImport
  extends BHistoryImport
{
  /*-
  
  class BFileHistoryImport
  {
    properties
    {
      file: BOrd
        -- The ord to the file to be imported.
        default {[ BOrd.NULL ]}
        slotfacets {[ BFacets.make(BFacets.TARGET_TYPE, "baja:IFile") ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.file.history.BFileHistoryImport(3297113114)1.0$ @*/
/* Generated Tue May 16 11:03:47 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "file"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>file</code> property.
   * The ord to the file to be imported.
   * @see javax.baja.driver.file.history.BFileHistoryImport#getFile
   * @see javax.baja.driver.file.history.BFileHistoryImport#setFile
   */
  public static final Property file = newProperty(0, BOrd.NULL,BFacets.make(BFacets.TARGET_TYPE, "baja:IFile") );
  
  /**
   * Get the <code>file</code> property.
   * @see javax.baja.driver.file.history.BFileHistoryImport#file
   */
  public BOrd getFile() { return (BOrd)get(file); }
  
  /**
   * Set the <code>file</code> property.
   * @see javax.baja.driver.file.history.BFileHistoryImport#file
   */
  public void setFile(BOrd v) { set(file,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFileHistoryImport.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

/////////////////////////////////////////////////////////////////
// EXECUTION
/////////////////////////////////////////////////////////////////

  /**
   * Execution time.  Resolves the file by calling back
   * to the parent BIFileDevice, and then uses the resolved
   * BIFile to call executeFileImport.
   */
  public void doExecute()
  {
    try
    {
      executeFileImport(((BIFileDevice)getDevice()).resolveFile(getFile()));
    }
    catch (Exception e)
    {
      executeFail(e);
    }
  }
    
  /**
   * Import the history from the target file.
   */
  public abstract void executeFileImport(BIFile file);

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  /**
   * Get the default icon for a file history import.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.make(BIcon.std("file.png"),
                                               BIcon.std("badges/import.png"));
  
}
