/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.alarm;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIRemoteAlarmRecipient;
import javax.baja.alarm.BIRemoteAlarmSource;
import javax.baja.driver.BDeviceExt;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BAlarmDeviceExt is the base class for mapping native alarms
 * in a device into the Baja alarm framework.
 *
 * @author    Brian Frank       
 * @creation  17 Oct 01
 * @version   $Revision: 23$ $Date: 2/22/06 2:53:39 PM EST$
 * @since     Baja 1.0
 */
public abstract class BAlarmDeviceExt
  extends BDeviceExt
  implements BIRemoteAlarmSource, BIRemoteAlarmRecipient
{ 

  /*-
  class BAlarmDeviceExt
  {
    properties
    {
      alarmClass: String
        -- Default alarmClass to route alarm to.
        -- If blank, use alarm's alarmClass.
        default {[ "defaultAlarmClass" ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("alarm:AlarmClassFE"), BFacets.UX_FIELD_EDITOR, BString.make("alarm:AlarmClassEditor")) ]}
      lastReceivedTime: BAbsTime
        flags {summary, readonly}
        default {[BAbsTime.NULL]}
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE) ]}
    }
    actions
    {
      routeAlarm(alarm: BAlarmRecord)
        flags {hidden}
        default {[ new BAlarmRecord() ]}
      ackAlarm(alarm: BAlarmRecord): BBoolean
        flags {hidden}
        default {[ new BAlarmRecord() ]}
    }
    topics
    {
    }
    
  }
  -*/

/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.alarm.BAlarmDeviceExt(1481074452)1.0$ @*/
/* Generated Wed May 09 15:49:55 EDT 2018 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "alarmClass"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code alarmClass} property.
   * Default alarmClass to route alarm to.
   * If blank, use alarm's alarmClass.
   * @see #getAlarmClass
   * @see #setAlarmClass
   */
  public static final Property alarmClass = newProperty(0, "defaultAlarmClass", BFacets.make(BFacets.FIELD_EDITOR, BString.make("alarm:AlarmClassFE"), BFacets.UX_FIELD_EDITOR, BString.make("alarm:AlarmClassEditor")));
  
  /**
   * Get the {@code alarmClass} property.
   * Default alarmClass to route alarm to.
   * If blank, use alarm's alarmClass.
   * @see #alarmClass
   */
  public String getAlarmClass() { return getString(alarmClass); }
  
  /**
   * Set the {@code alarmClass} property.
   * Default alarmClass to route alarm to.
   * If blank, use alarm's alarmClass.
   * @see #alarmClass
   */
  public void setAlarmClass(String v) { setString(alarmClass, v, null); }

////////////////////////////////////////////////////////////////
// Property "lastReceivedTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code lastReceivedTime} property.
   * @see #getLastReceivedTime
   * @see #setLastReceivedTime
   */
  public static final Property lastReceivedTime = newProperty(Flags.SUMMARY|Flags.READONLY, BAbsTime.NULL, BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE));
  
  /**
   * Get the {@code lastReceivedTime} property.
   * @see #lastReceivedTime
   */
  public BAbsTime getLastReceivedTime() { return (BAbsTime)get(lastReceivedTime); }
  
  /**
   * Set the {@code lastReceivedTime} property.
   * @see #lastReceivedTime
   */
  public void setLastReceivedTime(BAbsTime v) { set(lastReceivedTime, v, null); }

////////////////////////////////////////////////////////////////
// Action "routeAlarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code routeAlarm} action.
   * @see #routeAlarm(BAlarmRecord alarm)
   */
  public static final Action routeAlarm = newAction(Flags.HIDDEN, new BAlarmRecord(), null);
  
  /**
   * Invoke the {@code routeAlarm} action.
   * @see #routeAlarm
   */
  public void routeAlarm(BAlarmRecord alarm) { invoke(routeAlarm, alarm, null); }

////////////////////////////////////////////////////////////////
// Action "ackAlarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code ackAlarm} action.
   * @see #ackAlarm(BAlarmRecord alarm)
   */
  public static final Action ackAlarm = newAction(Flags.HIDDEN, new BAlarmRecord(), null);
  
  /**
   * Invoke the {@code ackAlarm} action.
   * @see #ackAlarm
   */
  public BBoolean ackAlarm(BAlarmRecord alarm) { return (BBoolean)invoke(ackAlarm, alarm, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAlarmDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  public abstract void doRouteAlarm(BAlarmRecord record)
    throws Exception;
    
  public abstract BBoolean doAckAlarm(BAlarmRecord record)
    throws Exception;

  /**
   * BAlarmDeviceExt should not have any children.
   */
  public boolean isChildLegal(BComponent parent)
  {
    return false;
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("navOnly/alarmService.png");

}
