/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver;

import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BNetworkExt is the abstract base class for network extensions
 * which provide sub-functionality under a BDeviceNetwork.
 *
 * @author    Brian Frank       
 * @creation  17 Jun 04
 * @version   $Revision: 1$ $Date: 6/17/04 2:01:52 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BNetworkExt
  extends BComponent
{ 

  /*-
  
  class BNetworkExt
  {
  
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.BNetworkExt(1633215647)1.0$ @*/
/* Generated Thu Jun 17 10:06:06 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNetworkExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Get the parent network.
   */
  public final BDeviceNetwork getNetwork()
  {
    return (BDeviceNetwork)getParent();
  }
  
////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  /**
   * This method is called when the extension should recompute
   * its status (or the status of its children).  It is called
   * whenever the status of the parent network is modified.
   */
  public void updateStatus()
  {
  }

}
