/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIDeviceFolder is the common interface for 
 * BDeviceNetwork and BDeviceFolder.
 *
 * @author    Brian Frank       
 * @creation  12 Sept 04
 * @version   $Revision: 1$ $Date: 9/12/04 1:39:32 PM EDT$
 * @since     Baja 1.0
 */
public interface BIDeviceFolder
  extends BInterface
{                       

  /**
   * Get the parent network.
   */
  public BDeviceNetwork getNetwork();

  /**
   * Get the type of Device for this driver.
   */
  public Type getDeviceType();

  /**
   * Get the type of DeviceFolder for this driver.
   */
  public Type getDeviceFolderType();
    
  
  public static final Type TYPE = Sys.loadType(BIDeviceFolder.class);

}
