/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver;

import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BDeviceExt is the abstract base class for device extensions
 * which provide feature integrations between the device's native
 * protocol and model and the framework's normalized model. 
 *
 * @author    Brian Frank       
 * @creation  17 Oct 01
 * @version   $Revision: 18$ $Date: 8/16/04 8:35:43 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BDeviceExt
  extends BComponent
{ 

  /*-
  
  class BDeviceExt
  {
  
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.BDeviceExt(3860572661)1.0$ @*/
/* Generated Thu Jun 17 09:04:44 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Get the grandparent network.
   */
  public final BDeviceNetwork getNetwork()
  {
    return getDevice().getNetwork();
  }
  
  /**
   * Get the parent device.
   */
  public final BDevice getDevice()
  {
    return (BDevice)getParent();
  }

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  /**
   * This method is called when the extension should recompute
   * its status (or the status of its children).  It is called
   * whenever the status the parent device is modified.
   */
  public void updateStatus()
  {
  }

}
