/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial.comm.singleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;

/**
 * This communicator is designed for use with a classic master-slave protocol
 * (possibly with unsolicited messages).
 *
 * This uses a single transaction manager to enforce that at most one request
 * for serial data be outstanding on the field-bus at any given time.
 * 
 * For more details, please see the Java Doc for com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr
 *
 * @author lperkins
 */
public class BDdfSerialSitCommunicator
  extends BDdfSerialCommunicator
{
  /*-
    class BDdfSerialSitCommunicator
    {
      properties
      {
        transactionManager : BDdfTransactionMgr
          -- Hooks up the ddf single transaction communicator with a ddf single transaction manager.
          default{[ new BDdfSingleTransactionMgr() ]}
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator(254779771)1.0$ @*/
/* Generated Mon Jun 04 16:54:35 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * Hooks up the ddf single transaction communicator with
   * a ddf single transaction manager.
   * @see com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator#getTransactionManager
   * @see com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfSingleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialSitCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfSerialSitCommunicator
////////////////////////////////////////////////////////////////
  
  /**
   * Descendant implementations of the BDdfReceiver typically call this if
   * they need to know the request that was recently transmitted and is awaiting
   * response.
   *
   * @return the BIDdfRequest that was last transmitted but no yet timed out, or null
   * if no message was last transmitted or if the last message that was transmitted
   * has already timed out.
   */
  public BIDdfRequest getOutstandingRequest()
  {
    return ((BDdfSingleTransactionMgr)getTransactionManager()).getOutstandingRequest();
  }


}
