/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial.comm.multipleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionMgr;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;

/**
 * This communicator allows multiple outstanding requests on the serial port
 * at the same time. This accommodates serial/wireless radio protocols where
 * a wireless radio is connected to the Niagara AX station as a serial port.
 * 
 * This uses a multiple transaction manager to allow a request for data
 * to be transmitted onto the field bus even though the data response may arrive
 * much later. In the mean time, the multiple transaction manager will allow
 * other requests to be transmitted onto the field-bus. The responses for those
 * requests likewise could arrive later after which even more requests can
 * be transmitted onto the field-bus.  
 * 
 * For more details, please see the Java Doc for com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionMgr
 * 
 * 
 * @author lperkins
 *
 */
public class BDdfSerialMutCommunicator
  extends BDdfSerialCommunicator
{
  /*-
    class BDdfSerialMutCommunicator
    {
      properties
      {
        transactionManager : BDdfTransactionMgr
          -- Customizes to use the standard BDdfMultipleTransactionMgr
          default{[ new BDdfMultipleTransactionMgr() ]}
      
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator(220188264)1.0$ @*/
/* Generated Wed Apr 04 17:05:01 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * Customizes to use the standard BDdfMultipleTransactionMgr
   * @see com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator#getTransactionManager
   * @see com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfMultipleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialMutCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
