/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddfSerial.comm.singleTransaction.BDdfSerialSitCommunicator;

/**
 * This is a Niagara AX driver network that is designed for use with a
 * classic master-slave serial protocol (possibly with unsolicited messages).
 * 
 * This uses a BDdfSerialSitCommunicator for single transaction access to
 * a serial field-bus.
 * 
 * The acronynm "Sit" stands for "Single Transaction".
 * 
 * Your driver can extend this class, redefine the communicator property, and
 * specify a communicator for your driver that extends BDdfSerialSitCommunicator
 * and customizes (at the very least) the receiver.
 * 
 * @author lperkins
 */
@SuppressWarnings("cast")
public abstract class BDdfSerialSitNetwork
  extends BDdfSerialNetwork
{
  /*-
    class BDdfSerialSitNetwork
    {
      properties
      {
        communicator : BValue
          -- Uses a single-transaction serial port communicator.
          -- The BValues for this property must implement BIDdfCommunicator 
          default{[ new BDdfSerialSitCommunicator() ]}
      }
    }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.BDdfSerialSitNetwork(755090505)1.0$ @*/
/* Generated Wed Apr 04 17:05:01 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Uses a single-transaction serial port communicator.
   * The BValues for this property must implement BIDdfCommunicator
   * @see com.tridium.ddfSerial.BDdfSerialSitNetwork#getCommunicator
   * @see com.tridium.ddfSerial.BDdfSerialSitNetwork#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfSerialSitCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfSerial.BDdfSerialSitNetwork#communicator
   */
  public BValue getCommunicator() { return (BValue)get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfSerial.BDdfSerialSitNetwork#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialSitNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
