/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp.comm.singleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr;
import com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator;

/**
 * This communicator is designed for use with a classic master-slave protocol
 * (possibly with unsolicited messages).
 *
 * This uses a single transaction manager to enforce that at most one request
 * for serial data be outstanding on the field-bus at any given time.
 *
 * @author lperkins
 */
public class BDdfUdpSitCommunicator
  extends BDdfUdpCommunicator
{
  /*-
  class BDdfUdpSitCommunicator
  {
    properties
    {
      transactionManager : BDdfTransactionMgr
        -- Hooks up the ddf single transaction communicator with a ddf single transaction manager.
        default{[ new BDdfSingleTransactionMgr() ]}
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.comm.singleTransaction.BDdfUdpSitCommunicator(3180758506)1.0$ @*/
/* Generated Thu Feb 14 10:05:07 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * Hooks up the ddf single transaction communicator with
   * a ddf single transaction manager.
   * @see com.tridium.ddfIp.udp.comm.singleTransaction.BDdfUdpSitCommunicator#getTransactionManager
   * @see com.tridium.ddfIp.udp.comm.singleTransaction.BDdfUdpSitCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfSingleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddfIp.udp.comm.singleTransaction.BDdfUdpSitCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddfIp.udp.comm.singleTransaction.BDdfUdpSitCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpSitCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
