/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp.comm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;

import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.util.Lexicon;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.udp.identify.BIDdfUdpDeviceId;

public class BDdfUdpTransmitter
  extends BDdfTransmitter
{
  /*-
   class BDdfUdpTransmitter
   {
     properties
     {
        sendToAddress : BDdfIpAddressPort
          -- Specifies the Udp/Ip address and port (on the field-device) to transmit to.
          -- DatagramPackets are sent to this location, unless the corresponding BIDdfRequst's
          -- device Id implements BIDdfUdpDeviceId, in which case the particular request will
          -- be sent to the Udp/Ip address identified by the request's Device Id.
          default{[new BDdfIpAddressPort()]}
          slotfacets{[MGR_INCLUDE]}
       maxRetryCount : int
         -- This is the default maximum number of times that any one message will ever be
         -- retransmitted. This property is faceted with MGR_INCLUDE so that it can appear
         -- in the device manager, if the device communicates on its own.
         default{[3]}
         slotfacets{[DdfFacets.combine( MGR_INCLUDE,
                                        BFacets.make(BFacets.MIN,BInteger.make(0)))]}
     }

   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter(214674391)1.0$ @*/
/* Generated Tue Aug 14 17:35:27 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "sendToAddress"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>sendToAddress</code> property.
   * Specifies the Udp/Ip address and port (on the field-device)
   * to transmit to. DatagramPackets are sent to this location,
   * unless the corresponding BIDdfRequst's device Id implements
   * BIDdfUdpDeviceId, in which case the particular request
   * will be sent to the Udp/Ip address identified by the
   * request's Device Id.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#getSendToAddress
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#setSendToAddress
   */
  public static final Property sendToAddress = newProperty(0, new BDdfIpAddressPort(),MGR_INCLUDE);

  /**
   * Get the <code>sendToAddress</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#sendToAddress
   */
  public BDdfIpAddressPort getSendToAddress() { return (BDdfIpAddressPort)get(sendToAddress); }

  /**
   * Set the <code>sendToAddress</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#sendToAddress
   */
  public void setSendToAddress(BDdfIpAddressPort v) { set(sendToAddress,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxRetryCount"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxRetryCount</code> property.
   * This is the default maximum number of times that any
   * one message will ever be retransmitted. This property
   * is faceted with MGR_INCLUDE so that it can appear in the device manager, if the device communicates on its own.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#getMaxRetryCount
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#setMaxRetryCount
   */
  public static final Property maxRetryCount = newProperty(0, 3,DdfFacets.combine( MGR_INCLUDE,
                                        BFacets.make(BFacets.MIN,BInteger.make(0))));

  /**
   * Get the <code>maxRetryCount</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#maxRetryCount
   */
  public int getMaxRetryCount() { return getInt(maxRetryCount); }

  /**
   * Set the <code>maxRetryCount</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter#maxRetryCount
   */
  public void setMaxRetryCount(int v) { setInt(maxRetryCount,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpTransmitter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  public BDdfUdpCommunicator getUdpCommunicator()
  {
    return (BDdfUdpCommunicator)getDdfCommunicator();
  }

  /**
   * This method places the given request's byte array into a datagram packet
   * and transmits it through the Udp Communicator's transmit socket.
   *
   * @param BIDdfRequest ddfRequest, the given request's deviceId must implement
   * BIDdfUdpDeviceId to specify the request packet's destination.
   */
  public void forceTransmit(BIDdfRequest ddfRequest) throws Exception
  {
    BDdfIpAddressPort destUdpAddr = getUdpSendToAddress(ddfRequest);
    byte[] udpData = ddfRequest.toByteArray();
    if (getDdfCommunicator().getLog().isTraceOn())
      trace(udpData,destUdpAddr);
    // Sends a new datagram packet containing the udp data destined to the udp destination address
    // that we just determined
    getUdpCommunicator().getUdpTransmitSocket().send(
        new DatagramPacket(udpData,
                           udpData.length,
                           destUdpAddr.getInetAddress(),
                           destUdpAddr.getIpPort() ));
  }

  public BDdfIpAddressPort getUdpSendToAddress(BIDdfRequest ddfRequest)
  {
    BDdfIdParams deviceIdForRequest = ddfRequest.getDeviceId();
    // If the given ddfRequest's deviceId specifies a Udp/Ip address
    // Then the ddfRequest's DatagramPacket will be addressed to there
    if (deviceIdForRequest instanceof BIDdfUdpDeviceId)
      return ((BIDdfUdpDeviceId)deviceIdForRequest).getUdpAddress();
    // Else, the given DdfRequest will be addressed to the transmitter's
    // "Send From Address"
    else
      return getSendToAddress();

  }

  private void trace(byte[] out, BDdfIpAddressPort udpAddress )
  {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.println("TX:"+udpAddress.getIpAddress()+':'+udpAddress.getIpPort());
    ByteArrayUtil.hexDump(pw,out,0,out.length);
    pw.flush();
    pw.close();
    getDdfCommunicator().getLog().trace(sw.toString());
  }

  /**
   * Gets the Udp port that the Udp DatagramSocket will be bound to on the host (Jace).
   *
   * @return this default implementation returns -1 which causes the BDdfUdpCommunicator
   * to allow Java to choose any available Udp port. If the developer's driver requires
   * a particular Udp origination port for the transmit socket then the developer may
   * override this method and supply a Udp Port as he or she sees fit.
   */
  public int getTransmitFromPort()
  {
    return -1;
  }

  public static final Lexicon LEX = Lexicon.make(BDdfUdpTransmitter.class);
  public static final String lexkeyRequestDoesNotSupportUdp = "RequestDoesNotSupportUdp";
  public static final String requestDoesNotSupportUdp = LEX.getText(lexkeyRequestDoesNotSupportUdp);
}
