/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp.comm;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddfIp.comm.BDdfIpAdapter;
import com.tridium.ddfIp.comm.BDdfIpCommunicator;

/**
 * Communicates over Udp/Ip.
 * 
 * The default 'transmitter' holds the Udp IP address and Udp port setting.
 * 
 * The default 'receiver' uses the same Udp IP address and Udp port as the 'transmitter'. If necessary,
 * the developer can change this by extending BDdfUdpReceiver, adding a BDdfUdpIpAddress property, and overriding
 * the getUdpAddress() method on his or her BDdfUdpReceiver to return the value of the new BDddfUdpIpAddress
 * property that would be added to the BDdfUdpReceiver.
 * 
 * Note:
 * Allows for the local Udp IP address and Udp port to be the same for sending Udp/Ip and
 * receiving Udp/Ip. This also allows for the local Udp IP address and Udp port to be
 * different for sending Udp/Ip and receiving Udp/Ip.
 *   
 * @author lperkins
 */
public class BDdfUdpCommunicator
  extends BDdfIpCommunicator
{
  /*-
   class BDdfUdpCommunicator
   {
      properties
      {
        transmitter : BDdfTransmitter
          -- Facilitates transmitting Udp/Ip packets from an IP address and port
          -- on the platform.
          default{[ new BDdfUdpTransmitter() ]}
          slotfacets{[MGR_INCLUDE]}
        receiver : BDdfReceiver
          -- Facilitates receiving Udp/Ip packets at an IP address and port on
          -- the platform
          default{[ new BDdfUdpReceiver() ]}
          slotfacets{[MGR_INCLUDE]}
      }
    }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator(713503534)1.0$ @*/
/* Generated Tue Jan 15 07:42:03 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transmitter"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transmitter</code> property.
   * Facilitates transmitting Udp/Ip packets from an IP
   * address and port on the platform.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#getTransmitter
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#setTransmitter
   */
  public static final Property transmitter = newProperty(0, new BDdfUdpTransmitter(),MGR_INCLUDE);
  
  /**
   * Get the <code>transmitter</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#transmitter
   */
  public BDdfTransmitter getTransmitter() { return (BDdfTransmitter)get(transmitter); }
  
  /**
   * Set the <code>transmitter</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#transmitter
   */
  public void setTransmitter(BDdfTransmitter v) { set(transmitter,v,null); }

////////////////////////////////////////////////////////////////
// Property "receiver"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>receiver</code> property.
   * Facilitates receiving Udp/Ip packets at an IP address
   * and port on the platform
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#getReceiver
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#setReceiver
   */
  public static final Property receiver = newProperty(0, new BDdfUdpReceiver(),MGR_INCLUDE);
  
  /**
   * Get the <code>receiver</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#receiver
   */
  public BDdfReceiver getReceiver() { return (BDdfReceiver)get(receiver); }
  
  /**
   * Set the <code>receiver</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator#receiver
   */
  public void setReceiver(BDdfReceiver v) { set(receiver,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  
//  /**
//   * Implements the 'checkIsPlatTcpAvailable' action.
//   */
//  public BBoolean doCheckIsPlatTcpAvailable()
//  {
//    try
//    { // Attempts to get a BVector of Ethernet adapters
//      // From the PlatTcpService.
//      getHostEthernetAdapters();
//      // If successfull then great!
//      return BBoolean.TRUE;
//    }
//    catch (Exception e)
//    { // If an exception is thrown, then the PlatTcpService
//      // Is not available...bummer!
//      return BBoolean.FALSE;
//    }
//  }
  
  
  
  /**
   * Checks if the given socket needs to be reinitialized.
   * 
   * @param socketAdapter a copy of the adapter in the same state that it was in when the given
   * socket was originally constructed
   * 
   * @param socket the socket to check to see if it needs to be reinitialized
   * 
   * @param currentAdapter the current adapter to use if the socket were to be re-intialized
   * 
   * @param currentPort the current port to bing the socket to if it were to be re-initialized
   * 
   * @return Returns true if the socketAdapter is not equivalent to the currentAdapter or if the socket's port
   * is not equal to the currentPort. Returns false otherwise.
   */
  protected boolean doesSocketNeedReInitialized(BDdfIpAdapter socketAdapter, DatagramSocket socket, int socketPort,
                                                BDdfIpAdapter currentAdapter, int currentPort)
  {
    if (socketAdapter == null)
      return true;
    else if (socketAdapter.equivalent(currentAdapter))
    {
      if (socket==null)
        return true;
      else
      {
        return socketPort != currentPort;
      }
    }
    else
      return true;
    //return( ( socketAdapter!=null &&  !socketAdapter.equivalent(currentAdapter) )||
    //        ( socket !=null && socket.getLocalPort() != currentPort ));
    
  }
  
  /**
   * Gets the socket to use for Udp/Ip transmissions.
   * 
   * @exception throw an exception, such as a SocketException or UnknownHostException. The UnknownHostException would apply to the
   * Jace's udp ip address.
   */
  public DatagramSocket getUdpTransmitSocket()
    throws Exception
  {
    synchronized(udpTransmitSocketLock)
    { // If the socket needs to be re-initialized (in other words, if the adapter or port settings have changed) 
      if( doesSocketNeedReInitialized(udpNetworkAdapter, udpTransmitSocket, udpTransmitPort, getNetworkAdapter(), getUdpTransmitPort()))
        cleanupUdpTransmitSocket();
      // The udpTransmitSocket will be null just after station boot and just after the transmitter's jaceIp changes
      if (udpTransmitSocket==null)
        makeUdpTransmitSocket();
      
      return udpTransmitSocket;
    }
  }
  
  /**
   * Gets the DatagramSocket to receive from, based on the current setting of the "Receive From" property of the "Udp Receiver"
   * 
   * @exception throw an exception, such as a SocketException or UnknownHostException. The UnknownHostException would apply to the
   * Jace's udp ip address.
   * 
   */
  public DatagramSocket getUdpReceiveSocket()
    throws Exception
  {
    synchronized (udpReceiveSocketLock)
    { 
      if( doesSocketNeedReInitialized(udpNetworkAdapter, udpReceiveSocket, udpReceivePort, getNetworkAdapter(), getUdpReceivePort()))
          cleanupUdpReceiveSocket();
      // The udpReceiveSocket will be null just after station boot and just after the receiver's "Receive From" property changes
      if (udpReceiveSocket==null)
        makeUdpReceiveSocket();
      return udpReceiveSocket;
    }
  }
  
  
  /**
   * Gets the port to use for Udp/Ip transmissions.
   * By default, this calls getUdpTransmitter().getTransmitFromPort();
   */
  public int getUdpTransmitPort()
  {
    return getUdpTransmitter().getTransmitFromPort();
  }
  
  /**
   * Gets the port to use for receiving Udp/Ip data.
   * By default, this calls getUdpReceiver().getReceivePort()
   */
  public int getUdpReceivePort()
  {
    return getUdpReceiver().getReceivePort();
  }
  
  public BDdfUdpTransmitter getUdpTransmitter()
  {
    return (BDdfUdpTransmitter)getDdfTransmitter();
  }
  public BDdfUdpReceiver getUdpReceiver()
  {
    return (BDdfUdpReceiver)getDdfReceiver();
  }
  
  /**
   * This is the override point for a developer to customize the
   * shutdown behavior.
   * 
   * @throws any exception may be thrown
   */
  public void udpCommunicatorStarted() throws Exception {}
  
  /**
   * This is the override point for a developer to customize the
   * shutdown behavior.
   * 
   * @throws any exception may be thrown
   */
  public void udpCommunicatorStopped() throws Exception {}
  
  public final void ipCommunicatorStarted() throws Exception
  {
    udpCommunicatorStarted();
  }
  
  public final void ipCommunicatorStopped() throws Exception
  {
    udpCommunicatorStopped();
    cleanupUdpTransmitSocket();
    cleanupUdpReceiveSocket();
  }
  
  
  /**
   * Makes a socket bound locally to the given bind port. The socket will be bound
   * to the default localhost.
   * 
   * @param bindPort
   * @return the requested socket
   * @throws SocketException
   */
  protected DatagramSocket makeLocalHostSocket(int bindPort)
    throws SocketException
  {
    if (bindPort<0)
      // Constructs a datagram socket bound to the default Ip Address and port. This lets Java
      // determine both the default Ip Address and the default port
      return new DatagramSocket( );
    else
      // Constructs a datagram socket bound to the default Ip Address and the user/developer
      // defined port. This lets Java determine the default Ip Address but let's us specify the port
      return  new DatagramSocket( bindPort );
  }
  
  
  protected DatagramSocket makeFullySpecifiedSocket(BDdfIpAdapter networkInterface, int bindPort)
    throws UnknownHostException, SocketException
  {
    if (bindPort<0)
    {
      // Constructs a datagram socket bound to the user/developer defined Ip Address. Java does
      // Not provide a mechanism of supplying an Ip Address without a port so we need to implement
      // Our own
      DatagramSocket tempSocket = null;
      for (int port = MIN_DYNAMIC_PORT; port<=MAX_DYNAMIC_PORT && tempSocket==null; port++)
      {
        try
        {
          tempSocket = new DatagramSocket( port, 
              InetAddress.getByName(networkInterface.getIpAddress()));
        }
        catch (SocketException se)
        { // Catches but does nothing...allowing the for loop to try the next port
        }
        catch (SecurityException se)
        { // Catches but does nothing...allowing the for loop to try the next port
        }
      }
      if (tempSocket==null)
        throw new SocketException("No Available Dynamic Port in Range ["+MIN_DYNAMIC_PORT+"-"+MAX_DYNAMIC_PORT+"]");
      else
        return tempSocket;
    }
    else
    {
      // Constructs a datagram socket bound to the Ip Address (or host name) and port as specified by the adapter
      // That the user chose
      return new DatagramSocket( bindPort,
                                 InetAddress.getByName(networkInterface.getIpAddress()));
    }

  }
  
  /**
   * Makes a socket for the given 'networkInterface'. If the port is -1 then any available port is
   * used.
   * 
   * If the 'networkInterface' specifies that the default, local host is to be used, then the JVM
   * chooses which Ip address to use.
   * 
   * If the 'networkInterface' defines what appears to be a valid adapterId and ipAddress then this
   * makes a socket bound to the ip address of teh 'networkInterface' and bound to the given bind
   * port
   * 
   * @param networkInterface a BDdfUdpIpAdapter structure that specifies the interface to use. This
   * should be a direct reference to the transmit-from adapter or the receive-to adapter, because
   * this method will directly update the structure in the event that it attempts to resolve the
   * network interface. As mentioned, this method will attempt to resolve the network interface if
   * this structure is a 'description-only' adapter (read above for details about this).
   * 
   * @param int bindPort the local (station-side-JVM) port to bind the Udp/Ip socket to.
   * 
   * @return the newly created and bound socket, if all goes well -- an exception is thrown otherwise
   * 
   * @throws SocketException if there is a general security violation preventing this method from
   * serving its purpose, or if the given networkInterface identifies an adapter that cannot be
   * found amoung the adapters that the Niagara AX Platfrom Tcp/Ip service reports.
   * 
   * @throws UnknownHostException if there is a problem with the ipAddress defined by the given
   * 'networkInterface'
   */
  protected DatagramSocket makeSocket(BDdfIpAdapter networkInterface, int bindPort)
    throws SocketException, UnknownHostException
  {
    // If the given udpSocketAddress is configured to use the so-called default Ip...
    if (networkInterface.isDefaultLocalHost())
    { 
      return makeLocalHostSocket(bindPort);
    }
    else // Else, the given udpSocketAddress defines an Ip...
    { 
      return makeFullySpecifiedSocket(networkInterface, bindPort);
    }
    
  }
  
  /**
   * Constructs a new socket to serve as the DatagramSocket that is used for sending
   * DatagramPacket objects. Construction is performed inside a lock on the local
   * udpTransmitSocketLock object.
   * 
   * @exception throw an exception, such as a SocketException or UnknownHostException. The UnknownHostException
   * would apply to the Jace's udp ip address as defined by the communicator's networkInterface.
   */
  protected void makeUdpTransmitSocket()
    throws Exception
  {
    synchronized(udpTransmitSocketLock)
    { 
      // Takes a snapshot of the BDdfUdpIpAdapter for the communicator
      // To buffer us against any changes while creating the socket
      udpNetworkAdapter = (BDdfIpAdapter)getNetworkAdapter().newCopy();
      udpTransmitPort = getUdpTransmitPort();
      // Makes a DatagramSocket to serve as the "udpTransmitSocket"
      udpTransmitSocket = makeSocket(udpNetworkAdapter, udpTransmitPort);
    }
    initUdpTransmitSocket();
  }
  
  /**
   * This is a callback to allow the developer to perform any intialization
   * communication as a result of instantiating a new Udp transmit socket.
   * 
   * This is called after processing a change to the udp transmit settings
   */
  protected void initUdpTransmitSocket()
    throws Exception
  {
    
  }
  
  /**
   * This is a callback to allow the developer to perform any intialization
   * communication as a result of instantiating a new Udp receive socket.
   * 
   * This is called after processing a change to the udp receive settings
   */
  protected void initUdpReceiveSocket()
    throws Exception
  {
    
  }
  
  /**
   * Constructs a new socket to serve as the DatagramSocket that is used for receiving
   * DatagramPacket objects. Construction is performed inside a lock on the local
   * udpReceiveSocketLock object.
   * 
   * Note: This checks if the receiver's Udp/Ip port is the same as the
   * transmitter's Udp/Ip port. If so, then this sets its internal reference
   * for the udpReceiveSocket equal to the return value of the 'getUdpTransmitSocket' method.
   * 
   * Of course, it is assumed that the Udp/Ip transmitter and Udp/Ip receiver use the same
   * network interface.
   * 
   * @exception throw an exception, such as a SocketException or UnknownHostException. The UnknownHostException would apply to the
   * Jace's udp ip address.
   */
  protected void makeUdpReceiveSocket()
    throws Exception
  {
    synchronized(udpReceiveSocketLock)
    { // Takes a snapshot of the BDdfUdpIpAdapter for the receiver
      // To buffer against changes to the network interface settings
      // While creating the receive-socket
      udpNetworkAdapter = (BDdfIpAdapter)getNetworkAdapter().newCopy();
      udpReceivePort = getUdpReceivePort();
      
      // We are about to check if the receive socket should be the same as the transmit
      // Socket. We need to lock the transmit socket so that we cannot change the transmit
      // Socket (in the unlikely event that we would ever be changing the transmit socket
      // while initializing the receiver socket) until after we finish setting the receiver
      // Socket equal to the transmitter socket.
      synchronized(udpTransmitSocketLock)
      { // In case the receiver starts before the transmitter then
        // This will cause the transmit socket to be created before
        // Checking the udpTransmitAddress. This is important otherwise
        // The udpReceiveSocket might not be assigned a direct reference
        // Of the udpTransmitSocket
        DatagramSocket transmitSocket = getUdpTransmitSocket();
        
        // Checks if the receivePort (receive into) is the same as the transmitPort (transmit from)
        if (udpReceivePort == udpTransmitPort)
        { // If the receive adapter and port number are the same as that being used for
          // The transmitter then we reuse the transmit socket as the receive socket.
          udpReceiveSocket = transmitSocket;
          return;
        }
        // else, we need our own Udp receive socket since the local recieve port differs from the
        // local transmit port. This falls  through and unlocks the udpTransmitSocketLock before
        // peforming the expensive operation to make the udpReceiveSocket
      }
      // Makes a DatagramSocket to serve as the "udpReceiveSocket"
      udpReceiveSocket = makeSocket(udpNetworkAdapter, udpReceivePort);
    }
  }  
  
  /**
   * This method calls 'close' on the Udp/Ip transmit socket and sets the internal
   * reference to the 'udpTransmitSocket' to null.
   */
  protected void cleanupUdpTransmitSocket()
  { // Closes the transmit socket and sets the udpTransmitSocket to null (the cleanupSocket method always returns null)
    udpTransmitSocket = cleanupSocket(udpTransmitSocket, udpTransmitSocketLock);
  }
  /**
   * This method calls 'close' on the Udp/Ip receive socket and sets the internal
   * reference to the 'udpReceiveSocket' to null.
   */
  protected void cleanupUdpReceiveSocket()
  { // Closes the receive socket and sets the udpReceiveSocket to null (the cleanupSocket method always returns null)
    udpReceiveSocket = cleanupSocket(udpReceiveSocket, udpReceiveSocketLock);
  }
  /**
   * Cleans up the given socket by calling "close()" on it. This is done within a
   * synchronized block on the given socketLock object.
   * 
   * @param cleanupSocket
   * @param socketLock
   * 
   * @return this method always returns null so that the caller can set its socket "equal"
   * to the return value of this method, thereby, null'ing out the reference to the
   * socket as soon as the socket is cleaned up.
   */
  protected static DatagramSocket cleanupSocket(DatagramSocket cleanupSocket, Object socketLock)
  {
    synchronized(socketLock)
    {
      if (cleanupSocket!=null)
      {
        cleanupSocket.close();
      }
      return null;
    }
  }
  
  /**
   * This is an internal reference to the DatagramSocket that is currently being used
   * for Udp/Ip sending.
   */
  protected DatagramSocket udpTransmitSocket=null;
  /**
   * This is an internal reference to the DatagramSocket that is currently being used
   * for Udp/Ip receiving.
   */
  protected DatagramSocket udpReceiveSocket=null;
  /**
   * This is an internal reference to a copy of the BDdfUdpIpAdapter that is currently
   * being used for all Udp/Ip communication.
   */
  protected BDdfIpAdapter udpNetworkAdapter=null;
  
  /**
   * This is an internal reference to a the Udp/Ip port that is currently
   * being used for Udp/Ip sending.
   */
  protected int udpTransmitPort=Integer.MIN_VALUE;
  
  /**
   * This is an internal reference to a the Udp/Ip port that is currently
   * being used for Udp/Ip receiving.
   */
  protected int udpReceivePort=Integer.MIN_VALUE;
  
  /**
   * This is an internal reference to an object that is used as a lock on the Udp/Ip
   * transmit socket. This lock object is used to prevent access to the transmit
   * socket if the transmit socket is being initialized or re-initialized.
   */
  protected final Object udpTransmitSocketLock = new Object(); // A plain 'Object' will suffice as a lock
  /**
   * This is an internal reference to an object that is used as a lock on the Udp/Ip
   * receive socket. This lock object is used to prevent access to the receive
   * socket if the receive socket is being initialized or re-initialized.
   */
  protected final Object udpReceiveSocketLock = new Object(); // A plain 'Object' will suffice as a lock
  
  
  public static final String lexkeyJaceSocketConnectionError = "JaceSocketConnectionError";
  public static final String lexkeyJaceUnknownHostException = "JaceUnknownHostException";
  public static final Lexicon LEX = Lexicon.make(BDdfUdpCommunicator.class);
}
