/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommNetwork;
import com.tridium.ddfIp.udp.comm.singleTransaction.BDdfUdpSitCommunicator;

/**
 * BDdfUdpGatewayNetwork is the driver network for devices that are behind
 * a Udp/Ip gateway. A Udp/Ip gateway is a unit of hardware that is connected to
 * a Udp/Ip network and also to one or more generic field-buses. It forwards
 * Udp/Ip communications from the Udp/Ip network to other devices that are
 * connected to its generic field-bus(es).
 *
 * In this type of installation, the BDdfUdpGatewayNetwork has a Udp/Ip
 * connection in the Niagara AX station. The individual devices do not have their
 * own Idp/Ip connection. Instead, the individual devices in the station
 * communicate through the BDdfUdpGatewayNetwork that is above them in the Niagara
 * AX navigation tree.
 *
 * This uses a BDdfUdpSitCommunicator because most Udp/Ip gateway networks provide
 * access to older equipment that is typically serial, master-slave in nature. If
 * a developer ever needs a multiple transaction gateway then the developer
 * can create a communicator that extends BDdfUdpMutCommunicator, then extend this
 * class, and redefine the "communicator" property to use a default a the developer's
 * "Udp MUT" communicator.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.2
 */
public abstract class BDdfUdpGatewayNetwork
  extends BDdfCommNetwork
{
  /*-
  class BDdfUdpGatewayNetwork
  {
    properties
    {
      communicator : BValue
        -- Places the Udp/Ip communications directly onto the network. Devices
        -- Under this network should extend from BDdfUdpDeviceBehindGateway.
        -- BDdfUdpDeviceBehindGateway uses this communicator for field communications
        -- To the actual physical device.
        default{[ new BDdfUdpSitCommunicator() ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.BDdfUdpGatewayNetwork(4051922830)1.0$ @*/
/* Generated Thu Feb 14 10:05:07 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Places the Udp/Ip communications directly onto the
   * network. Devices Under this network should extend from BDdfUdpDeviceBehindGateway. BDdfUdpDeviceBehindGateway uses this communicator for field communications To the actual physical device.
   * @see com.tridium.ddfIp.udp.BDdfUdpGatewayNetwork#getCommunicator
   * @see com.tridium.ddfIp.udp.BDdfUdpGatewayNetwork#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfUdpSitCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfIp.udp.BDdfUdpGatewayNetwork#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfIp.udp.BDdfUdpGatewayNetwork#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpGatewayNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
