/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.tcp.comm.multipleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionMgr;
import com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator;

/**
 * This is a version of the BDdfTcpCommunicator that uses
 * a BDdfMultipleTransactionMgr to allow for requests to
 * be transmitted without the driver having to wait for the
 * response before transmitting the next request.
 * 
 * For more details, please review the Java Doc for com.tridium.ddf.comm.multipleTransaction.BDdfMultipleTransactionMgr
 * 
 * @author lperkins
 *
 */
public class BDdfTcpMutCommunicator
  extends BDdfTcpCommunicator
{
  /*-
   class BDdfTcpMutCommunicator
   {
     properties
     {
      transactionManager : BDdfTransactionMgr
        -- Customizes to use the standard BDdfMultipleTransactionMgr
        default{[ new BDdfMultipleTransactionMgr() ]}       
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator(692312882)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * Customizes to use the standard BDdfMultipleTransactionMgr
   * @see com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator#getTransactionManager
   * @see com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfMultipleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpMutCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
