/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddfIp.tcp.comm;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.ByteArrayUtil;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * BDdfTcpTransmitter
 *
 * @author    lperkins
 * @creation  Oct 17, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BDdfTcpTransmitter
  extends BDdfTransmitter
{
  /*-
  class BDdfTcpTransmitter
  {
    properties
    {
       maxRetryCount : int
         -- This is the default maximum number of times that any one message will ever be
         -- retransmitted
         -- This is where this BDdfTcpHelper will connect.
         -- This is flagged as summary so that it
         -- Can appear in the device manager, if the device communicates on
         -- Its own.
         default{[10]}
         slotfacets{[DdfFacets.combine(DdfFacets.MGR_INCLUDE,
                                        BFacets.make(BFacets.MIN,BInteger.make(0)))]}
     }

  }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.comm.BDdfTcpTransmitter(2452316110)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "maxRetryCount"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxRetryCount</code> property.
   * This is the default maximum number of times that any
   * one message will ever be retransmitted This is where
   * this BDdfTcpHelper will connect. This is flagged as
   * summary so that it Can appear in the device manager,
   * if the device communicates on Its own.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpTransmitter#getMaxRetryCount
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpTransmitter#setMaxRetryCount
   */
  public static final Property maxRetryCount = newProperty(0, 10,DdfFacets.combine(DdfFacets.MGR_INCLUDE,
                                        BFacets.make(BFacets.MIN,BInteger.make(0))));

  /**
   * Get the <code>maxRetryCount</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpTransmitter#maxRetryCount
   */
  public int getMaxRetryCount() { return getInt(maxRetryCount); }

  /**
   * Set the <code>maxRetryCount</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpTransmitter#maxRetryCount
   */
  public void setMaxRetryCount(int v) { setInt(maxRetryCount,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpTransmitter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfTransmitter
////////////////////////////////////////////////////////////////


  /* (non-Javadoc)
   * @see com.tridium.ddfTcp.comm.BIDdfTransmitter#devForceTransmit(com.tridium.ddfTcp.comm.req.BIDdfRequest)
   */
  public void forceTransmit(BIDdfRequest devRequest)
    throws Exception
  {
    // TODO Auto-generated method stub
    byte[] out = devRequest.toByteArray();
    if (getDdfCommunicator().getLog().isTraceOn())
      trace(out);
    ((BDdfTcpCommunicator)getDdfCommunicator()).getTcpSocketManager().writeOutputStream(out, 0, out.length);
  }

  private void trace(byte[] out)
  {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.println("TX:");
    ByteArrayUtil.hexDump(pw,out,0,out.length);
    pw.flush();
    pw.close();
    getDdfCommunicator().getLog().trace(sw.toString());
  }

}
