/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddfIp.tcp.comm;

import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;

/**
 * BDdfTcpReceiver
 * 
 * Descendants need to extend this class and implement the following methods:
 * 
 * isCompleteFrame(...)
 * 
 * isStartOfFrame(...)
 *
 * @author    lperkins
 * @creation  Oct 17, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfTcpReceiver
  extends BDdfReceiver
{
  /*-
   class BDdfTcpReceiver
   {
     properties
     {
        responseTimeout : BRelTime
          -- Descendants should redefine this property appropriately.
          -- This is where this BDdfTcpHelper will connect.
          -- This is flagged as summary so that it 
          -- Can appear in the device manager, if the device communicates on
          -- Its own.
          default{[BRelTime.makeSeconds(1)]}
         slotfacets{[DdfFacets.combine(DdfFacets.MGR_INCLUDE,
                                        BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE), 
                                        BFacets.make(BFacets.MIN,BRelTime.make(0)))]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.comm.BDdfTcpReceiver(336507788)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "responseTimeout"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>responseTimeout</code> property.
   * Descendants should redefine this property appropriately.
   * This is where this BDdfTcpHelper will connect. This
   * is flagged as summary so that it Can appear in the
   * device manager, if the device communicates on Its own.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpReceiver#getResponseTimeout
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpReceiver#setResponseTimeout
   */
  public static final Property responseTimeout = newProperty(0, BRelTime.makeSeconds(1),DdfFacets.combine(DdfFacets.MGR_INCLUDE,
                                        BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE), 
                                        BFacets.make(BFacets.MIN,BRelTime.make(0))));
  
  /**
   * Get the <code>responseTimeout</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpReceiver#responseTimeout
   */
  public BRelTime getResponseTimeout() { return (BRelTime)get(responseTimeout); }
  
  /**
   * Set the <code>responseTimeout</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpReceiver#responseTimeout
   */
  public void setResponseTimeout(BRelTime v) { set(responseTimeout,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpReceiver.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfReceiver
////////////////////////////////////////////////////////////////
  
  /** 
   * Hooks into BDdfReceiver. BDdfReceiver calls readByte as necessary to construct
   * incoming messages. This implementation of readByte reads the next byte off of the
   * TcpSocketManager's piped input stream. The TcpSocketManager's piped input stream
   * is fed by a corresponding piped output stream into which the TcpSocketManager
   * writes all incoming Tcp data.
   */
  protected int readByte()
    throws Exception
  {
    return ((BDdfTcpCommunicator)getDdfCommunicator()).getTcpSocketManager().readByte();
  }
}
