/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddfIp.tcp.comm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddfIp.comm.BDdfIpAdapter;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.comm.BDdfIpCommunicator;

/**
 * This is used as a property on the BDdfTcpCommunicator to define
 * the IP address and IP port of the field-device or field-gateway
 * to which the driver will communicate. This also defines the Tcp/Ip
 * socket connection timeout.
 *  
 * @author lperkins
 */
public class BDdfTcpHelper
  extends BStruct
  implements IDdfFacetConst
{
  /*-
  class BDdfTcpHelper
  {
    properties
    {
      destinationAddress : BDdfIpAddressPort
        -- Encapsulates the ipAddress and port for the Tcp/Ip target server.
        -- This is flagged as summary so that it
        -- Can appear in the device manager, if the device communicates on
        -- Its own.
        default{[new BDdfIpAddressPort()]}
        slotfacets{[MGR_INCLUDE]}
      socketConnectionTimeout : BRelTime
         -- This defines the amount of time to wait when establishing the Tcp connection before timing out
         default{[BRelTime.makeSeconds(30)]}
         slotfacets{[BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE), 
                                  BFacets.MIN,BRelTime.make(1))]}
        
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.comm.BDdfTcpHelper(2833857593)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "destinationAddress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>destinationAddress</code> property.
   * Encapsulates the ipAddress and port for the Tcp/Ip
   * target server. This is flagged as summary so that it Can appear in the device manager, if the device communicates on Its own.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#getDestinationAddress
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#setDestinationAddress
   */
  public static final Property destinationAddress = newProperty(0, new BDdfIpAddressPort(),MGR_INCLUDE);
  
  /**
   * Get the <code>destinationAddress</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#destinationAddress
   */
  public BDdfIpAddressPort getDestinationAddress() { return (BDdfIpAddressPort)get(destinationAddress); }
  
  /**
   * Set the <code>destinationAddress</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#destinationAddress
   */
  public void setDestinationAddress(BDdfIpAddressPort v) { set(destinationAddress,v,null); }

////////////////////////////////////////////////////////////////
// Property "socketConnectionTimeout"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>socketConnectionTimeout</code> property.
   * This defines the amount of time to wait when establishing
   * the Tcp connection before timing out
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#getSocketConnectionTimeout
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#setSocketConnectionTimeout
   */
  public static final Property socketConnectionTimeout = newProperty(0, BRelTime.makeSeconds(30),BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE), 
                                  BFacets.MIN,BRelTime.make(1)));
  
  /**
   * Get the <code>socketConnectionTimeout</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#socketConnectionTimeout
   */
  public BRelTime getSocketConnectionTimeout() { return (BRelTime)get(socketConnectionTimeout); }
  
  /**
   * Set the <code>socketConnectionTimeout</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpHelper#socketConnectionTimeout
   */
  public void setSocketConnectionTimeout(BRelTime v) { set(socketConnectionTimeout,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpHelper.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////
  public String toString(Context context)
  {
    return getDestinationAddress().getIpAddress()+':'+getDestinationAddress().getIpPort();
  }
  
////////////////////////////////////////////////////////////////
// BDdfTcpHelper API
////////////////////////////////////////////////////////////////
  
  public Socket createSocket() throws IOException
  {
    return createSocket(getTcpCommunicator().getNetworkInterface(), getLocalPort());
  }

  /**
   * If the developer's Tcp protocol requires a specific local bind port, then the developer should override this method
   * and define the specific local bind port.
   * 
   * @return by default, this returns -1. This causes the 'createSocket' logic to use any available port to bind to
   *         locally.
   */
  public int getLocalPort()
  {
    return -1;
  }

  public BDdfTcpCommunicator getTcpCommunicator()
  {
    if (tcpCommunicator == null)
    {
      // Caches the tcpCommunicator. This is important for client-side
      // video stream communications. Otherwise, this object's getParent()
      // method will eventually return null as the Niagara AX core will
      // eventually attempt to cleanup its proxy
      tcpCommunicator = (BDdfTcpCommunicator)getParent();
    }
    
    // Returns the cached tcpCommunicator reference
    return tcpCommunicator;
  }

  

  protected Socket createSocket(BDdfIpAdapter networkInterface, int bindPort)
    throws IOException
  {
    // If the given udpSocketAddress is configured to use the so-called default Ip...
    if (networkInterface.isDefaultLocalHost())
    { 
      return makeLocalHostSocket(bindPort);
    }
    else // Else, the given udpSocketAddress defines an Ip...
    { 
      return makeFullySpecifiedSocket(networkInterface, bindPort);
    }    
  }
  
  /**
   * Makes a Tcp/Ip socket bound locally to the given bind port. The socket will be bound
   * to the default localhost.
   * 
   * @param bindPort
   * @return the requested socket
   * @throws IOException
   */
  protected Socket makeLocalHostSocket(int bindPort)
    throws IOException
  {
    if (bindPort<0)
      // Constructs a Tcp/Ip socket bound to the default Ip Address and port. This lets Java
      // determine both the default Ip Address and the default port
      return new Socket(getDestinationAddress().getIpAddress(),
                        getDestinationAddress().getIpPort());
    else
      // Constructs a Tcp/Ip socket bound to the default Ip Address and the user/developer
      // defined port. This lets Java determine the default Ip Address but let's us specify the port
      return  null;//new Socket( bindPort );
  }  
  
  protected Socket makeFullySpecifiedSocket(BDdfIpAdapter networkInterface, int bindPort)
    throws IOException
  {
    if (bindPort<0)
    {
      // Constructs a Tcp/Ip socket bound to the user/developer defined Ip Address. Java does
      // Not provide a mechanism of supplying an Ip Address without a port so we need to implement
      // Our own
      Socket tempSocket = null;
      for (int port = BDdfIpCommunicator.MIN_DYNAMIC_PORT; port<=BDdfIpCommunicator.MAX_DYNAMIC_PORT && tempSocket==null; port++)
      {
        try
        {
          tempSocket = new Socket( getDestinationAddress().getIpAddress(),
                                   getDestinationAddress().getIpPort(),
                                   InetAddress.getByName(networkInterface.getIpAddress()),
                                   port);
        }
        catch (SocketException se)
        { // Catches but does nothing...allowing the for loop to try the next port
        }
        catch (SecurityException se)
        { // Catches but does nothing...allowing the for loop to try the next port
        }
      }
      if (tempSocket==null)
        throw new SocketException("No Available Dynamic Port in Range ["+BDdfIpCommunicator.MIN_DYNAMIC_PORT+"-"+BDdfIpCommunicator.MAX_DYNAMIC_PORT+"]");
      else
        return tempSocket;
    }
    else
    {
      // Constructs a Tcp/Ip socket bound to the Ip Address (or host name) and port as specified by the adapter
      // That the user chose
      return new Socket( getDestinationAddress().getIpAddress(),
                         getDestinationAddress().getIpPort(),
                         InetAddress.getByName(networkInterface.getIpAddress()),
                         bindPort);
    }
  
  }
  
  
  ////////////////////////////////////////////////////////////////
  // Presentation
  ////////////////////////////////////////////////////////////////

  /**
   * Get the icon.
   */
  public BIcon getIcon()
  {
    return icon;
  }
  
  /**
   * Added after the release of this jar, must restrict access to
   * ensure API stability.
   */
  BDdfTcpCommunicator tcpCommunicator;

  private static final BIcon icon = BIcon.std("connection.png");
  
  
}
