/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddfIp.tcp;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfDevice;

/**
 * BDdfTcpDeviceBehindGateway - Devices that extend this device should reside
 * under a BDdfTcpGatewayNetwork. The Niagara-AX Tcp/Ip connection is on the BDdfTcpGatewayNetwork
 * and is shared by all BDdfTcpDeviceBehindGateway devices.
 *
 * In general, this is used to represent a field device that is physically connected
 * to a field-bus, which is connected to a gateway unit, which is connected to a Tcp/Ip network.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.2
 */
public abstract class BDdfTcpDeviceBehindGateway
  extends BDdfDevice
{
  /*-
  class BDdfTcpDeviceBehindGateway
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.BDdfTcpDeviceBehindGateway(3797253287)1.0$ @*/
/* Generated Thu Feb 14 10:05:07 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpDeviceBehindGateway.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
