/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddfIp.tcp;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommDevice;
import com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator;

/**
 * BDdfTcpDevice is used to access a field device that is directly
 * connected to a Tcp/Ip network. The BDdfTcpDevice in the Niagara AX
 * station will be given its own Tcp/Ip connection.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.2
 */
public abstract class BDdfTcpDevice
  extends BDdfCommDevice
{
  /*-
  class BDdfTcpDevice
  {
    properties
    {
      communicator : BValue
        -- Gives the device its own dedicated Tcp/Ip connection.
        default{[ new BDdfTcpMutCommunicator() ]}
        slotfacets{[MGR_INCLUDE]} 
    }
  } 
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.BDdfTcpDevice(1947520909)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Gives the device its own dedicated Tcp/Ip connection.
   * @see com.tridium.ddfIp.tcp.BDdfTcpDevice#getCommunicator
   * @see com.tridium.ddfIp.tcp.BDdfTcpDevice#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfTcpMutCommunicator(),MGR_INCLUDE);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfIp.tcp.BDdfTcpDevice#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfIp.tcp.BDdfTcpDevice#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
