/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.comm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents an Ethernet port on a platform that runs a station. 
 * 
 */
public class BDdfIpAdapter
  extends BStruct
{
  /*-
  class BDdfIpAdapter
  {
    properties
    {
      adapterId: String
      -- OS identifier for the network adapter (interface ID for *nix, guid for
      -- win32, etc.)
        default {[ "" ]}
      description: String
      -- OS description for the adapter, if available
        default {[ "" ]}
      ipAddress: String
      -- The ip address configured for the adapter
        default {[ "" ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.comm.BDdfIpAdapter(1465021288)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "adapterId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>adapterId</code> property.
   * OS identifier for the network adapter (interface ID
   * for *nix, guid for win32, etc.)
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#getAdapterId
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#setAdapterId
   */
  public static final Property adapterId = newProperty(0, "",null);
  
  /**
   * Get the <code>adapterId</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#adapterId
   */
  public String getAdapterId() { return getString(adapterId); }
  
  /**
   * Set the <code>adapterId</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#adapterId
   */
  public void setAdapterId(String v) { setString(adapterId,v,null); }

////////////////////////////////////////////////////////////////
// Property "description"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>description</code> property.
   * OS description for the adapter, if available
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#getDescription
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#setDescription
   */
  public static final Property description = newProperty(0, "",null);
  
  /**
   * Get the <code>description</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#description
   */
  public String getDescription() { return getString(description); }
  
  /**
   * Set the <code>description</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#description
   */
  public void setDescription(String v) { setString(description,v,null); }

////////////////////////////////////////////////////////////////
// Property "ipAddress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ipAddress</code> property.
   * The ip address configured for the adapter
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#getIpAddress
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#setIpAddress
   */
  public static final Property ipAddress = newProperty(0, "",null);
  
  /**
   * Get the <code>ipAddress</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#ipAddress
   */
  public String getIpAddress() { return getString(ipAddress); }
  
  /**
   * Set the <code>ipAddress</code> property.
   * @see com.tridium.ddfIp.comm.BDdfIpAdapter#ipAddress
   */
  public void setIpAddress(String v) { setString(ipAddress,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfIpAdapter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfIpAdapter(){}
  public BDdfIpAdapter(String id, String desc, String ip)
  {
    setAdapterId(id);
    setDescription(desc);
    setIpAddress(ip);
  }
  
////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////
 /**
  * Makes an adpater that represents the host's "default" adapter.
  * 
  * When the DdfIpAdapter is the "default host" adapter, the ddf
  * asks Java to choose the "default" adapter. Since all operating
  * system vendors implement their own JVM, the Java "default"
  * adapter should be a good choice in a "don't care" scenario when
  * someone just wants the driver to communicate over any available
  * network interface.
  */
 public static BDdfIpAdapter makeDefaultLocalHost()
 {
   return new BDdfIpAdapter(DEFAULT_ADAPTER_ID,
       DEFAULT_DESCRIPTION,DEFAULT_IP_ADDR);
 }
  
////////////////////////////////////////////////////////////////
// BDdfIpAdapter
////////////////////////////////////////////////////////////////
 
  /**
   * Determines if this instance is configured to identify the host's
   * default adapter.
   */
  public boolean isDefaultLocalHost()
  {
    return getAdapterId().equals(DEFAULT_ADAPTER_ID) &&
           getDescription().equals(DEFAULT_DESCRIPTION) &&
           getIpAddress().equals(DEFAULT_IP_ADDR);
  }
  
  /**
   * This method is called by the BIpAdpaterEditor if the
   * user enters a description free-handedly. In this case,
   * the user is configuring the station in an offline
   * mode. The DDf Ip Communicator will attempt to match up
   * the 'adapterId' and 'ipAddress' when the station runs.
   * 
   * @param desc the description that the user entered
   * free-handedly into the BDDfIpAdapterEditor.
   */
  public void becomeDescriptionOnlyAdapter(String desc)
  {
    setDescription(desc);
    setAdapterId( DEFAULT_ADAPTER_ID );
    setIpAddress( DEFAULT_IP_ADDR );
  }
  /**
   * Checks if this is configured such that a description has been specified
   * but nothing else. The BDdfIpAdapterEditor uses this scenario if the
   * user is editing the station offline.
   * 
   * @return true if the description is not at default but the adapterId is at default.
   */
  public boolean isDescriptionOnlyAdapter()
  {
    return ( (!(getDescription().equals(DEFAULT_DESCRIPTION))) && // The description is not the default description
                getAdapterId().equals(DEFAULT_ADAPTER_ID)      ); // But the adapterId is the default adapter id
    
  }
  
  /**
   * This method is called by the BDdfIpAdapterEditor if the
   * user selects the "[Default Local Host]" adapter. The
   * Ip Communicator will ask Java to choose the local host.
   */
  public void becomeDefaultLocalHostAdapter()
  {
    setDescription( DEFAULT_DESCRIPTION );
    setAdapterId( DEFAULT_ADAPTER_ID );
    setIpAddress( DEFAULT_IP_ADDR );
  }
  
  /**
   * Gets the java.net.InetAddress representing this structure's "Ip Address"
   * 
   * @return the java.net.InetAddress object representing the ipAddress. If
   * the ip address is the adapter's default then this returns Sys.getLocalHost().
   * 
   * @throws UnknownHostException If this is a 'description' only adapter (meaning this
   * has not been resolved to a network interface on the host platform computer) then
   * this throws an UnknownHostException. This also throws any UnknownHostException
   * that the InetAddress.getByName mehtod throws as a result of calling it and passing
   * in the ipAddress for this adapter.
   * 
   */
  public InetAddress getInetAddress()
    throws UnknownHostException
  {
    if (isDefaultLocalHost())
    {
      //NCCB-12273: Continue to use default definition of local host until
      //requirements of hint in this context can be defined
      return Sys.getLocalHost(null);
    }
    else if (isDescriptionOnlyAdapter())
      throw new UnknownHostException("Unrecognized network interface: "+getDescription());
    else
      return InetAddress.getByName(getIpAddress());
  }  
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  
  public static final String DEFAULT_ADAPTER_ID = "[***DEFAULT***]";
  public static final String DEFAULT_IP_ADDR = "[***DEFAULT***]";
  public static final String DEFAULT_DESCRIPTION = "[***DEFAULT***]";
}
