/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.identify;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Classes that extend BDdfIdParams and provide a URL for use in the devHttpDriver framework should
 * implement this interface.
 * 
 * This is part of the devHttpDriver 'inspect' support whose purpose is
 * to allow drivers to inspect (comb) web pages for data and import the
 * data into a Niagara AX station as a standard Niagara AX driver control
 * point.
 *  
 * Note that BDdfHttpInspectDeviceId and BDdfHttpInspectReadParams implement this interface.
 * 
 * @see BDdfHttpInspectDeviceId
 * @see BDdfHttpInspectReadParams
 * 
 * @author lperkins
 */
public interface BIDdfHttpInspectUrl
  extends BInterface
{
  
  /**
   * Defines the URL to connect to.
   * 
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams#url 
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams#getUrl()
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId#url 
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId#getUrl()
   */
  public String getUrl();
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
 
 public static final Type TYPE = Sys.loadType(BIDdfHttpInspectUrl.class);

}
