/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.identify;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This is part of the devHttpDriver 'inspect' support whose purpose is
 * to allow drivers to inspect (comb) web pages for data and import the
 * data into a Niagara AX station as a standard Niagara AX driver control
 * point.
 * 
 * @author lperkins
 */
public interface BIDdfHttpInspectExpression
    extends BInterface
{
  /**
   * Defines the regular expression that is used to parse the data
   * value for a particular data point from the text of an HTTP
   * response.
   * 
   * A perl 5 regular expression search is performed. The HTTP response
   * data is used as the source input for the regular expression search.
   * The string that this method returns is used as the regular expression
   * syntax to search for.
   * 
   * The actual value for the data point will be extracted as the text
   * that matches a group of matching parethesis in the regular expression
   * string that this method returns.
   * 
   * Note that BDdfHttpInspectPointId implements this interface.
   * 
   * @see #getRegExpGroup()
   * @see BDdfHttpInspectPointId#regExp()
   * @see BDdfHttpInspectPointId#getRegExp()
   * 
   * @return a Perl 5 regular expression string.
   */
  public String getRegExp();
  
  /**
   * This is used in conjunction with the string that is returned
   * by the 'getRegExp' method. This defines which set of parenthesis
   * should be used to extract the data point value from the text that
   * the regular expression matches.
   * 
   * @return an integer that identifies which set of parenthesis to
   * extract matching text from in order to parse the raw value of
   * the data point.
   * 
   * @see #getRegExp()
   * @see BDdfHttpInspectPointId#regExp
   * @see BDdfHttpInspectPointId#getRegExp()
  * 
   */
  public int getRegExpGroup();
  
  ////////////////////////////////////////////////////////////////
  //Type
  ////////////////////////////////////////////////////////////////
  
  public static final Type TYPE = Sys.loadType(BIDdfHttpInspectExpression.class);

}
