/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.identify;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfReadParams;
import com.tridium.ddfHttp.comm.req.BDdfHttpInspectReadRequest;

/**
 * This is part of the devHttpDriver 'inspect' support whose purpose is
 * to allow drivers to inspect (comb) web pages for data and import the
 * data into a Niagara AX station as a standard Niagara AX driver control
 * point.
 *  
 * @author lperkins
 *
 */
public class BDdfHttpInspectReadParams
    extends BDdfReadParams
    implements BIDdfHttpInspectUrl
{
  /*-
   class BDdfHttpInspectReadParams
   {
     properties
     {
       url : String
         -- This is the address of the HTTP server to get a result from. Behind the scenes,
         -- the driver will simulate a web browser connecting to this address. To submit data
         -- as part of the request, simply add a question mark in this field after the URL.
         -- After that, add as many name value pairs as necessary, each separated by an
         -- ampersand '&' character. If present, then this form data will be presented to
         -- the corresponding web server as part of an HTTP GET operation. Alternatively,
         -- to pass this data as part of an HTTP POST operation, simply add the text "POST"
         -- followed by a space to the front of this string.
         -- <br>
         -- @see com.tridium.ddfHttp.identify.BIDdfHttpInspectUrl#getUrl()
         
         default{["-"]}
         slotfacets{[MGR_INCLUDE]}
         
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams(2306652469)1.0$ @*/
/* Generated Fri Feb 22 15:02:18 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "url"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>url</code> property.
   * This is the address of the HTTP server to get a result
   * from. Behind the scenes, the driver will simulate a web browser connecting to this address. To submit data as part of the request, simply add a question mark in this field after the URL. After that, add as many name value pairs as necessary, each separated by an ampersand '&' character. If present, then this form data will be presented to the corresponding web server as part of an HTTP GET operation. Alternatively, to pass this data as part of an HTTP POST operation, simply add the text "POST" followed by a space to the front of this string. <br> @see com.tridium.ddfHttp.identify.BIDdfHttpInspectUrl#getUrl()
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams#getUrl
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams#setUrl
   */
  public static final Property url = newProperty(0, "-",MGR_INCLUDE);
  
  /**
   * Get the <code>url</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams#url
   */
  public String getUrl() { return getString(url); }
  
  /**
   * Set the <code>url</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectReadParams#url
   */
  public void setUrl(String v) { setString(url,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpInspectReadParams.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  public Type getReadRequestType()
  {
    return BDdfHttpInspectReadRequest.TYPE;
  }

}
