/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.identify;

import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.identify.BDdfIdParams;

/**
 * This is part of the devHttpDriver 'inspect' support whose purpose is
 * to allow drivers to inspect (comb) web pages for data and import the
 * data into a Niagara AX station as a standard Niagara AX driver control
 * point.
 * 
 * @author lperkins
 *
 */
public class BDdfHttpInspectPointId
    extends BDdfIdParams
    implements BIDdfHttpInspectExpression
{

  /*-
   class BDdfHttpInspectPointId
   {
     properties
     {
       regExp : String
         -- This property's getter helps satisfy the BIDdfHttpInspectExpression interface.
         -- The devDriver framework will scan through the HTTP response for the data
         -- point's value by running the HTTP response text through a Perl5 regular
         -- expression search. This string defines the pattern to search for.
         -- <br>
         -- @see com.tridium.ddfHttp.identify.BIDdfHttpInspectExpression#getRegExp
         default{[""]}
         slotfacets{[ DdfFacets.combine(
                        MGR_INCLUDE,
                        MGR_OPTIONAL_IN_TABLE) ]}
                        
       regExpGroup : int
         -- This property's getter helps satisfy the BIDdfHttpInspectExpression interface.
         -- This identifies the group of parenthesis from the regExp pattern whose 
         -- matched text represents the data point value.
         -- <br> 
         -- @see com.tridium.ddfHttp.identify.BIDdfHttpInspectExpression#getRegExpGroup
         default{[0]}
         slotfacets{[ DdfFacets.combine(
                        BFacets.make( BFacets.MIN, BInteger.make(0) ),
                        MGR_INCLUDE,
                        MGR_OPTIONAL_IN_TABLE) ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.identify.BDdfHttpInspectPointId(552329160)1.0$ @*/
/* Generated Fri Feb 22 14:58:06 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "regExp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>regExp</code> property.
   * This property's getter helps satisfy the BIDdfHttpInspectExpression
   * interface. The devDriver framework will scan through
   * the HTTP response for the data point's value by running
   * the HTTP response text through a Perl5 regular expression
   * search. This string defines the pattern to search for. <br> @see com.tridium.ddfHttp.identify.BIDdfHttpInspectExpression#getRegExp
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#getRegExp
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#setRegExp
   */
  public static final Property regExp = newProperty(0, "",DdfFacets.combine(
                        MGR_INCLUDE,
                        MGR_OPTIONAL_IN_TABLE));
  
  /**
   * Get the <code>regExp</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#regExp
   */
  public String getRegExp() { return getString(regExp); }
  
  /**
   * Set the <code>regExp</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#regExp
   */
  public void setRegExp(String v) { setString(regExp,v,null); }

////////////////////////////////////////////////////////////////
// Property "regExpGroup"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>regExpGroup</code> property.
   * This property's getter helps satisfy the BIDdfHttpInspectExpression
   * interface. This identifies the group of parenthesis
   * from the regExp pattern whose matched text represents
   * the data point value. <br> @see com.tridium.ddfHttp.identify.BIDdfHttpInspectExpression#getRegExpGroup
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#getRegExpGroup
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#setRegExpGroup
   */
  public static final Property regExpGroup = newProperty(0, 0,DdfFacets.combine(
                        BFacets.make( BFacets.MIN, BInteger.make(0) ),
                        MGR_INCLUDE,
                        MGR_OPTIONAL_IN_TABLE));
  
  /**
   * Get the <code>regExpGroup</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#regExpGroup
   */
  public int getRegExpGroup() { return getInt(regExpGroup); }
  
  /**
   * Set the <code>regExpGroup</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectPointId#regExpGroup
   */
  public void setRegExpGroup(int v) { setInt(regExpGroup,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpInspectPointId.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
