/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.identify;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.BDdfDeviceId;
import com.tridium.ddfHttp.comm.req.BDdfHttpInspectPingRequest;


/**
 * This is part of the devHttpDriver 'inspect' support whose purpose is
 * to allow drivers to inspect (comb) web pages for data and import the
 * data into a Niagara AX station as a standard Niagara AX driver control
 * point.
 * 
 * @author lperkins
 */
public class BDdfHttpInspectDeviceId
    extends BDdfDeviceId
    implements BIDdfHttpInspectUrl
{
  /*-
   class BDdfHttpInspectDeviceId
   {
     properties
     {
       url : String 
         -- This property's getter helps to satisfy the BIDdfHttpInspectUrl interface.
         -- This is the address of an HTTP server. When the Niagara AX frame and the devDriver
         -- framework attempt to perform a device status ping check, then behind the scenes,
         -- the driver will simulate a web browser connecting to this address. To submit data
         -- as part of the request, simply add a question mark in this field after the URL.
         -- After that, add as many name value pairs as necessary, each separated by an
         -- ampersand '&' character. If present, then this form data will be presented to
         -- the corresponding web server as part of an HTTP GET operation. Alternatively,
         -- to pass this data as part of an HTTP POST operation, simply add the text "POST"
         -- followed by a space to the front of this string.
         -- <br>
         -- @see com.tridium.ddfHttp.identify.BIDdfHttpInspectUrl#getUrl()
         default{["-"]}
         slotfacets{[MGR_INCLUDE]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId(1700079386)1.0$ @*/
/* Generated Fri Feb 22 15:02:18 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "url"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>url</code> property.
   * This property's getter helps to satisfy the BIDdfHttpInspectUrl
   * interface. This is the address of an HTTP server. When the Niagara AX frame and the devDriver framework attempt to perform a device status ping check, then behind the scenes, the driver will simulate a web browser connecting to this address. To submit data as part of the request, simply add a question mark in this field after the URL. After that, add as many name value pairs as necessary, each separated by an ampersand '&' character. If present, then this form data will be presented to the corresponding web server as part of an HTTP GET operation. Alternatively, to pass this data as part of an HTTP POST operation, simply add the text "POST" followed by a space to the front of this string. <br> @see com.tridium.ddfHttp.identify.BIDdfHttpInspectUrl#getUrl()
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId#getUrl
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId#setUrl
   */
  public static final Property url = newProperty(0, "-",MGR_INCLUDE);
  
  /**
   * Get the <code>url</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId#url
   */
  public String getUrl() { return getString(url); }
  
  /**
   * Set the <code>url</code> property.
   * @see com.tridium.ddfHttp.identify.BDdfHttpInspectDeviceId#url
   */
  public void setUrl(String v) { setString(url,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpInspectDeviceId.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public Type getPingRequestType()
  {
    return BDdfHttpInspectPingRequest.TYPE;
  }

}
