/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfHttp.comm.rsp;

import java.util.regex.Matcher;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.ddfHttp.identify.BIDdfHttpInspectExpression;

public class BDdfHttpInspectReadResponse
    extends BDdfResponse
    implements BIDdfReadResponse
{
  /*-
   class BDdfHttpInspectReadResponse
   {
     properties
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfHttp.comm.rsp.BDdfHttpInspectReadResponse(909427254)1.0$ @*/
/* Generated Fri Feb 22 14:52:47 EST 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfHttpInspectReadResponse.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BDdfHttpInspectReadResponse() {}

  public BDdfHttpInspectReadResponse(IDdfDataFrame httpResponseData, String urlAddress)
  {
    this.urlAddress = urlAddress;
    byte httpResponseBytes[] = new byte[ httpResponseData.getFrameSize() ];

    // Copies the bytes from the httpResponseData to a local safe copy
    System.arraycopy( httpResponseData.getFrameBytes(),
                      0,
                      httpResponseBytes,
                      0,
                      httpResponseData.getFrameSize() );

    // Stores the copy of the bytes from the httpResponseData inside a String
    // on the instance.
    this.htmlText = new String(httpResponseBytes);
  }

  /**
   * Implementing this method is fundamental to the ddf's
   * auto-poll feature for driver points. When one or more driver points
   * under a device need polled that share the equivalent read parameters,
   * the ddf will instantiate the read request type that
   * is identified by the read parameters, assign the read parameters to the
   * read request, assign all points that share the read parameters to the
   * request, and transmit the read request. Upon receiving a successful
   * read response (an instance that implements this interface), the ddf
   * driver framework will loop through all of the points under the device
   * that shared the same read parameters, cast each point to IDdfReadable,
   * and pass each point successively to this method. The developer driver
   * framework will take the return value from this method and pass it
   * to the readOk method on the point, thereby updating its value in Niagara.
   *
   * When implementing this interface, driver developers must implement this
   * method and parse a BStatusValue from the response data for the given
   * readableSource. If necessary, we suggest that the driver developer can
   * check if the readableSource object is an instance of their driver's proxy
   * extension class. If so, the driver developer can cast the readableSource
   * object to their driver's proxy extension class and then access the point's
   * pointId property. The driver developer should design the pointId property
   * in such a way that it provides the information necessary to parse the
   * particular point's value from the read response.
   *
   *
   * @param readableSource
   * @return a BStatusValue to pass to the readOk method of the readableSource
   */
  public BStatusValue parseReadValue(IDdfReadable readableSource)
  {
    // Verify that the given readableSource is an instance of DdfTridiumWebsite
    // driver's proxy extension
    if (readableSource instanceof BDdfProxyExt)
    {
      // Casts the given readableSource into a BDdfTridiumWebsiteProxyExt
      BDdfProxyExt proxy = (BDdfProxyExt)readableSource;

      // Gets the point id of the given proxy
      BDdfIdParams pointId = proxy.getPointId();

      if (pointId instanceof BIDdfHttpInspectExpression)
      {
        BIDdfHttpInspectExpression httpInspectResult = (BIDdfHttpInspectExpression)pointId;
        return getReadValue(proxy,httpInspectResult);
      }
      else
      {
        return null;
      }

    }
    else
    {
      return null;
    }
  }

  protected double parseNumericValue(String sRawValue)
  {
    try
    {
      // Attempts to parse the string as a 64-bit integer
      return (double)Long.parseLong(sRawValue);
    }
    catch (NumberFormatException nfe)
    {
      // If that fails then this attempts to parse the string
      // as a 64-bit double-precision floating-point value
      return Double.parseDouble(sRawValue);
    }

  }

  /**
   * This private method is called from the parseReadValue method.
   * It is not required by the developer driver framework, instead,
   * this method exists in order to shorten the parseReadValue method.
   *
   * @param a reference to the BDdfTridiumWebsiteProxyExt to parse the read
   * value for.
   *
   * @param a reference to the BDdfTridiumWebsitePointId to use to tell us
   * how to parse the read value from the response bytes.
   *
   * @return a BStatusNumeric, BStatusBoolean, BStatusEnum, or
   * BStatusString that appropriately matches the proxy's control
   * point type. If the proxy's control point is a BNumericWritable
   * or BNumericPoint then this will return a BStatusNumeric that
   * represents the present value of the point. If the proxy's
   * control point is a BBooleanWritable or a BBooleanPoint then
   * this returns a BStatusBoolean that represents the current value
   * of the point. If the proxy's control point is a BEnumWritable
   * or BEnumPoint then this returns BStatusEnum that represents the
   * current value of the point. If this proxy's control point is a
   * BStringPoint or BStringWritable then this returns a BStatusString
   * that represents the current value of the point.
   */
  protected BStatusValue getReadValue(BDdfProxyExt proxy,
      BIDdfHttpInspectExpression inspectResult)
  {
    // Gets the raw value for the given proxy
    String sRawValue = inspectHtml( proxy, inspectResult );

    BControlPoint controlPoint = proxy.getParentPoint();

    if (sRawValue == null)
    {
      // If the control point type is boolean then return a BStatusBoolean
      // of false to indicate that the pattern does not exist
      if (controlPoint instanceof BIBoolean)
        return new BStatusBoolean( false );
      else
        // Else, throw a runtime exception to flag the point as 'fault'
        throw new BajaRuntimeException("RegEx Pattern Not Found: "+
                                       inspectResult.getRegExp()+
                                       "\nUrl: "+ urlAddress +
                                       "\nSlot: "+
                                       proxy.getSlotPath() );
    }


    // Checks if the control point is a Numeric Writable or Numeric
    // Point component.
    if (controlPoint instanceof BINumeric)
    {
      return new BStatusNumeric( parseNumericValue(sRawValue));
    }
    // Checks if the control point is a Boolean Writable or a Boolean
    // Point component. NOTE: We must check boolean before enum because
    // a BIBoolean is also a BIEnum!
    else if (controlPoint instanceof BIBoolean)
    {
      // This is all we need to do. Any polarity conversion, etc. is
      // specified and handled elsewhere in Niagara AX
      return new BStatusBoolean(true);
    }
    // Checks if the control point is an Enum Writable or an Enum Point
    // component.
    else if (controlPoint instanceof BIEnum)
    {
      // A slight extra step is imperative for Enum Points to preserve
      // any dynamic enum range (text to ordinal mapping).
      BStatusEnum e = ((BEnumPoint)controlPoint).getOut();

      try
      {
        // Attempts to parse the raw value as a number
        double d = parseNumericValue(sRawValue);

        // Returns a BStatusEnum with the same ordinal as the number
        // that was just parsed for the sRawValue
        return new BStatusEnum( BDynamicEnum.make(
                                                  (int)Math.round(d),
                                                  e.getValue().getRange()));
      }
      catch (NumberFormatException nfe)
      {
        // Gets the dynamic enum whose ordinal would represent the tag. This
        // hopes that sRawValue is the correct tag
        BEnum newEnum = e.getValue().getRange().get(sRawValue);

        // Returns the BStatusEnum for the newEnum
        return new BStatusEnum( BDynamicEnum.make(
                                                  newEnum.getOrdinal(),
                                                  e.getValue().getRange()));
      }

    }
    else if (controlPoint instanceof BStringPoint)
    {
      return new BStatusString(sRawValue);
    }
    else
    {
      throw new IllegalStateException(
        "Unsupported control point type: "+
        controlPoint.getType()+"! Please have my program fixed.");
    }
  }

  protected String inspectHtml(BDdfProxyExt proxy,
                               BIDdfHttpInspectExpression pointInspectInfo)
  {
    Pattern oroPattern=null;

    try
    {
      oroPattern=Pattern.compile(pointInspectInfo.getRegExp());
    }
    catch (PatternSyntaxException e)
    {
      throw new BajaRuntimeException(e);
    }

    Matcher oroMatcher = oroPattern.matcher(htmlText);
    if (oroMatcher.find())
    {
      MatchResult oroResult = oroMatcher.toMatchResult();
      return oroResult.group( pointInspectInfo.getRegExpGroup() );
    }
    else
      return null;

  }

////////////////////////////////////////////////////////////////
//Attributes
////////////////////////////////////////////////////////////////

  protected String htmlText;

  protected String urlAddress;

}
